/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="DuplicatePropertyName", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicatePropertyNameCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.OBJECT_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        HashSet values = Sets.newHashSet();
        List propertyAssignments = astNode.getChildren(new AstNodeType[]{EcmaScriptGrammar.PROPERTY_ASSIGNMENT});
        for (AstNode propertyAssignment : propertyAssignments) {
            String unescaped;
            AstNode propertyName = propertyAssignment.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.PROPERTY_NAME});
            String value = propertyName.getTokenValue();
            if (value.startsWith("\"") || value.startsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if (values.contains(unescaped = EscapeUtils.unescape(value))) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename or remove duplicate property name '" + value + "'.", propertyName, new Object[0]);
                continue;
            }
            values.add(unescaped);
        }
    }
}

