/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ElseIfWithoutElse", priority=Priority.MAJOR)
public class ElseIfWithoutElseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode node) {
        AstNode elseClause;
        if (this.isElseIf(node) && (elseClause = node.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE})) == null) {
            this.getContext().createLineViolation((CodeCheck)this, "End this if...else if construct by an else clause.", node, new Object[0]);
        }
    }

    private boolean isElseIf(AstNode node) {
        return this.isElse(node.getParent().getParent());
    }

    private boolean isElse(AstNode node) {
        return node != null && node.is(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE});
    }
}

