/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="FunctionDefinitionInsideLoop", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionDefinitionInsideLoopCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Integer> stack;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.ITERATION_STATEMENT, EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION});
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.push(0);
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.ITERATION_STATEMENT})) {
            this.stack.push(this.stack.pop() + 1);
        } else {
            if (this.stack.peek() > 0) {
                this.getContext().createLineViolation((CodeCheck)this, "Define this function outside of a loop.", astNode, new Object[0]);
            }
            this.stack.add(0);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.ITERATION_STATEMENT})) {
            this.stack.push(this.stack.pop() - 1);
        } else {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }
}

