/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="RedeclaredVariable", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RedeclaredVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> stack;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION});
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            HashSet<String> currentScope = new HashSet<String>();
            this.stack.add(currentScope);
            AstNode formalParameterList = astNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST});
            if (formalParameterList != null) {
                for (int i = 0; i < formalParameterList.getNumberOfChildren(); i += 2) {
                    String parameterName = formalParameterList.getChild(i).getTokenValue();
                    currentScope.add(parameterName);
                }
            }
        } else {
            String variableName;
            Set<String> currentScope = this.stack.peek();
            if (currentScope.contains(variableName = astNode.getTokenValue())) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename variable '" + variableName + "' as this name is already used.", astNode, new Object[0]);
            } else {
                currentScope.add(variableName);
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }
}

