/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1126", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class ReturnOfBooleanExpressionCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        if (ReturnOfBooleanExpressionCheck.isNotIfElse(astNode) && ReturnOfBooleanExpressionCheck.hasElse(astNode) && ReturnOfBooleanExpressionCheck.returnsBoolean(ReturnOfBooleanExpressionCheck.getTrueStatement(astNode)) && ReturnOfBooleanExpressionCheck.returnsBoolean(ReturnOfBooleanExpressionCheck.getFalseStatement(astNode))) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this if-then-else statement by a single return statement.", astNode, new Object[0]);
        }
    }

    public static AstNode getTrueStatement(AstNode ifStmt) {
        return ifStmt.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE}).getFirstChild(new AstNodeType[]{EcmaScriptGrammar.STATEMENT});
    }

    public static AstNode getFalseStatement(AstNode ifStmt) {
        return ifStmt.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.STATEMENT});
    }

    public static boolean isNotIfElse(AstNode ifStmt) {
        return !ifStmt.getParent().getParent().is(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE});
    }

    public static boolean hasElse(AstNode ifStmt) {
        return ifStmt.hasDirectChildren(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE});
    }

    public static boolean returnsBoolean(AstNode statement) {
        return ReturnOfBooleanExpressionCheck.isBlockReturningBooleanLiteral(statement) || ReturnOfBooleanExpressionCheck.isSimpleReturnBooleanLiteral(statement);
    }

    public static boolean isBlockReturningBooleanLiteral(AstNode statement) {
        AstNode block = statement.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BLOCK});
        if (block == null) {
            return false;
        }
        AstNode stmtList = block.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.STATEMENT_LIST});
        return stmtList != null && stmtList.getChildren(new AstNodeType[]{EcmaScriptGrammar.STATEMENT}).size() == 1 && ReturnOfBooleanExpressionCheck.isSimpleReturnBooleanLiteral(stmtList.getFirstChild());
    }

    public static boolean isSimpleReturnBooleanLiteral(AstNode statement) {
        AstNode returnStmt = statement.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.RETURN_STATEMENT});
        if (returnStmt == null) {
            return false;
        }
        AstNode expression = returnStmt.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.EXPRESSION});
        return ReturnOfBooleanExpressionCheck.hasASingleToken(expression) && (EcmaScriptKeyword.TRUE.getValue().equals(expression.getTokenValue()) || EcmaScriptKeyword.FALSE.getValue().equals(expression.getTokenValue()));
    }

    private static boolean hasASingleToken(AstNode expression) {
        return expression != null && expression.getFirstChild().getToken().equals(expression.getLastToken());
    }
}

