/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1301", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class SwitchWithNotEnoughCaseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CASE_BLOCK});
    }

    public void visitNode(AstNode astNode) {
        if (SwitchWithNotEnoughCaseCheck.isLessThanThreeCases(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this \"switch\" statement with \"if\" statements to increase readability.", astNode, new Object[0]);
        }
    }

    public static boolean isLessThanThreeCases(AstNode caseBlock) {
        int numberOfCase = 0;
        for (AstNode caseClauses : caseBlock.getChildren(new AstNodeType[]{EcmaScriptGrammar.CASE_CLAUSES})) {
            numberOfCase += caseClauses.getChildren(new AstNodeType[]{EcmaScriptGrammar.CASE_CLAUSE}).size();
        }
        if (caseBlock.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.DEFAULT_CLAUSE}) != null) {
            ++numberOfCase;
        }
        return numberOfCase < 3;
    }
}

