/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="TrailingComma", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class TrailingCommaCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.ARRAY_LITERAL, EcmaScriptGrammar.OBJECT_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getLastChild().getPreviousSibling().getType() == EcmaScriptPunctuator.COMMA) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid trailing comma in array and object literals.", astNode, new Object[0]);
        }
    }
}

