/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;

public class IdentifierUtils {
    private IdentifierUtils() {
    }

    public static List<AstNode> getCatchIdentifiers(AstNode catchNode) {
        Preconditions.checkArgument((boolean)catchNode.is(new AstNodeType[]{EcmaScriptGrammar.CATCH}));
        AstNode parameterChild = catchNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.CATCH_PARAMETER}).getFirstChild();
        ArrayList identifiers = Lists.newArrayList();
        if (parameterChild.is(new AstNodeType[]{EcmaScriptGrammar.BINDING_IDENTIFIER})) {
            AstNode identifier = parameterChild.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
            if (identifier != null) {
                identifiers.add(identifier);
            }
        } else {
            identifiers.addAll(IdentifierUtils.getBindingPatternIdentifiers(parameterChild));
        }
        return identifiers;
    }

    public static List<AstNode> getVariableIdentifiers(AstNode variableDeclaration) {
        Preconditions.checkArgument((boolean)variableDeclaration.is(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.LEXICAL_BINDING, EcmaScriptGrammar.LEXICAL_DECLARATION_NO_IN}));
        ArrayList identifiers = Lists.newArrayList();
        AstNode child = variableDeclaration.getFirstChild();
        if (child.is(new AstNodeType[]{EcmaScriptGrammar.BINDING_IDENTIFIER_INITIALISER, EcmaScriptGrammar.BINDING_IDENTIFIER_INITIALISER_NO_IN})) {
            AstNode identifier = child.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_IDENTIFIER}).getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
            if (identifier != null) {
                identifiers.add(identifier);
            }
        } else {
            identifiers.addAll(IdentifierUtils.getBindingPatternIdentifiers(child.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_PATTERN})));
        }
        return identifiers;
    }

    public static List<AstNode> getArrowParametersIdentifier(AstNode arrowParameters) {
        Preconditions.checkArgument((boolean)arrowParameters.is(new AstNodeType[]{EcmaScriptGrammar.ARROW_PARAMETERS}));
        ArrayList identifiers = Lists.newArrayList();
        AstNode child = arrowParameters.getFirstChild();
        if (child.is(new AstNodeType[]{EcmaScriptGrammar.BINDING_IDENTIFIER}) && child.getFirstChild().is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) {
            identifiers.add(child.getFirstChild());
        } else {
            AstNode restParameter;
            AstNode expression = child.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.EXPRESSION});
            if (expression != null) {
                for (AstNode expressionChild : expression.getChildren()) {
                    if (!expressionChild.isNot(new AstNodeType[]{EcmaScriptPunctuator.COMMA})) continue;
                    identifiers.add(expressionChild);
                }
            }
            if ((restParameter = child.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.REST_PARAMETER})) != null) {
                identifiers.add(IdentifierUtils.getRestIdentifier(restParameter.getFirstChild()));
            }
        }
        return identifiers;
    }

    public static List<AstNode> getParametersIdentifier(AstNode formalParameterList) {
        Preconditions.checkArgument((boolean)formalParameterList.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST, EcmaScriptGrammar.PROPERTY_SET_PARAMETER_LIST}));
        ArrayList identifiers = Lists.newArrayList();
        for (AstNode parameter : formalParameterList.getChildren(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER, EcmaScriptGrammar.REST_PARAMETER})) {
            if (parameter.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER})) {
                identifiers.addAll(IdentifierUtils.getFormalParameterIdentifiers(parameter));
                continue;
            }
            AstNode id = IdentifierUtils.getRestIdentifier(parameter.getFirstChild());
            if (id == null) continue;
            identifiers.add(id);
        }
        return identifiers;
    }

    private static List<AstNode> getFormalParameterIdentifiers(AstNode formalParameter) {
        Preconditions.checkArgument((boolean)formalParameter.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER}));
        return IdentifierUtils.getBindingElementIdentifiers(formalParameter.getFirstChild());
    }

    private static List<AstNode> getBindingElementIdentifiers(AstNode bindingElement) {
        Preconditions.checkArgument((boolean)bindingElement.is(new AstNodeType[]{EcmaScriptGrammar.BINDING_ELEMENT}));
        AstNode child = bindingElement.getFirstChild();
        if (child.is(new AstNodeType[]{EcmaScriptGrammar.SINGLE_NAME_BINDING})) {
            return IdentifierUtils.getSingleNameIdentifier(child);
        }
        return IdentifierUtils.getBindingPatternIdentifiers(child);
    }

    private static List<AstNode> getBindingPatternIdentifiers(AstNode bindingPattern) {
        Preconditions.checkArgument((boolean)bindingPattern.is(new AstNodeType[]{EcmaScriptGrammar.BINDING_PATTERN}));
        AstNode child = bindingPattern.getFirstChild();
        if (child.is(new AstNodeType[]{EcmaScriptGrammar.OBJECT_BINDING_PATTERN})) {
            return IdentifierUtils.getObjectBindingIdentifiers(child);
        }
        return IdentifierUtils.getArrayBindingIdentifiers(child);
    }

    private static List<AstNode> getArrayBindingIdentifiers(AstNode arrayBindingPatter) {
        AstNode id;
        AstNode restElement;
        Preconditions.checkArgument((boolean)arrayBindingPatter.is(new AstNodeType[]{EcmaScriptGrammar.ARRAY_BINDING_PATTERN}));
        AstNode elementList = arrayBindingPatter.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_ELEMENT_LIST});
        ArrayList identifiers = Lists.newArrayList();
        if (elementList != null) {
            for (AstNode elisionElement : elementList.getChildren(new AstNodeType[]{EcmaScriptGrammar.BINDING_ELISION_ELEMENT})) {
                identifiers.addAll(IdentifierUtils.getBindingElementIdentifiers(elisionElement.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_ELEMENT})));
            }
        }
        if ((restElement = arrayBindingPatter.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_REST_ELEMENT})) != null && (id = IdentifierUtils.getRestIdentifier(restElement)) != null) {
            identifiers.add(id);
        }
        return identifiers;
    }

    @Nullable
    private static AstNode getRestIdentifier(AstNode bindingRestElement) {
        Preconditions.checkArgument((boolean)bindingRestElement.is(new AstNodeType[]{EcmaScriptGrammar.BINDING_REST_ELEMENT}));
        return bindingRestElement.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_IDENTIFIER}).getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
    }

    private static List<AstNode> getObjectBindingIdentifiers(AstNode objectBindingPattern) {
        Preconditions.checkArgument((boolean)objectBindingPattern.is(new AstNodeType[]{EcmaScriptGrammar.OBJECT_BINDING_PATTERN}));
        ArrayList identifiers = Lists.newArrayList();
        AstNode propertyList = objectBindingPattern.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_PROPERTY_LIST});
        if (propertyList != null) {
            for (AstNode property : propertyList.getChildren(new AstNodeType[]{EcmaScriptGrammar.BINDING_PROPERTY})) {
                AstNode propertyChild = property.getFirstChild();
                if (propertyChild.is(new AstNodeType[]{EcmaScriptGrammar.SINGLE_NAME_BINDING})) {
                    identifiers.addAll(IdentifierUtils.getSingleNameIdentifier(propertyChild));
                    continue;
                }
                identifiers.addAll(IdentifierUtils.getBindingElementIdentifiers(property.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_ELEMENT})));
            }
        }
        return identifiers;
    }

    private static List<AstNode> getSingleNameIdentifier(AstNode singleNameBinding) {
        Preconditions.checkArgument((boolean)singleNameBinding.is(new AstNodeType[]{EcmaScriptGrammar.SINGLE_NAME_BINDING}));
        ArrayList identifier = Lists.newArrayList();
        AstNode id = singleNameBinding.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.BINDING_IDENTIFIER}).getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
        if (id != null) {
            identifier.add(id);
        }
        return identifier;
    }
}

