/*
 * SonarQube JavaScript Plugin
 * Copyright (C) 2011 SonarSource and Eriks Nukis
 * dev@sonar.codehaus.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.javascript.checks;

public class Tags {

  public static final String BACKBONE = "backbone";
  public static final String BAD_PRACTICE = "bad-practice";
  public static final String BRAIN_OVERLOAD = "brain-overload";
  public static final String BUG = "bug";
  public static final String CERT = "cert";
  public static final String CLUMSY = "clumsy";
  public static final String CONFUSING = "confusing";
  public static final String CONVENTION = "convention";
  public static final String CROSS_BROWSER = "cross-browser";
  public static final String CWE = "cwe";
  public static final String INJECTION = "injection";
  public static final String LOCK_IN = "lock-in";
  public static final String MISRA = "misra";
  public static final String OBSOLETE = "obsolete";
  public static final String OWASP_A3 = "owasp-a3";
  public static final String OWASP_A6 = "owasp-a6";
  public static final String PITFALL = "pitfall";
  public static final String SECURITY = "security";
  public static final String UNUSED = "unused";
  public static final String USER_EXPERIENCE = "user-experience";

  private Tags() {
    // This class only defines constants
  }
  
}
