/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class ComplexityVisitor
extends SquidAstVisitor<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.METHOD, EcmaScriptGrammar.GENERATOR_METHOD, EcmaScriptGrammar.GENERATOR_EXPRESSION, EcmaScriptGrammar.GENERATOR_DECLARATION, EcmaScriptGrammar.IF_STATEMENT, EcmaScriptGrammar.ITERATION_STATEMENT, EcmaScriptGrammar.CASE_CLAUSE, EcmaScriptGrammar.CATCH, EcmaScriptGrammar.RETURN_STATEMENT, EcmaScriptGrammar.THROW_STATEMENT, EcmaScriptPunctuator.QUERY, EcmaScriptPunctuator.ANDAND, EcmaScriptPunctuator.OROR});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.RETURN_STATEMENT}) && ComplexityVisitor.isLastReturnStatement(astNode)) {
            return;
        }
        this.getContext().peekSourceCode().add((MetricDef)EcmaScriptMetric.COMPLEXITY, 1.0);
    }

    private static boolean isLastReturnStatement(AstNode returnNode) {
        AstNode nextNode = returnNode.getNextAstNode();
        return nextNode.is(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE}) && ComplexityVisitor.isNotNested(returnNode);
    }

    private static boolean isNotNested(AstNode returnNode) {
        AstNode parent = returnNode.getParent().getParent();
        return parent.getParent().is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_BODY});
    }
}

