/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum EcmaScriptGrammar implements GrammarRuleKey
{
    EOF,
    EOS,
    EOS_NO_LB,
    IDENTIFIER_NAME,
    CONDITION,
    LITERAL,
    NULL_LITERAL,
    BOOLEAN_LITERAL,
    STRING_LITERAL,
    TEMPLATE_LITERAL,
    SUBSTITUTION_TEMPLATE,
    NO_SUBSTITUTION_TEMPLATE,
    TEMPLATE_SUBSTITUTION_TAIL,
    TEMPLATE_HEAD,
    TEMPLATE_SPANS,
    TEMPLATE_TAIL,
    TEMPLATE_MIDDLE_LIST,
    TEMPLATE_MIDDLE,
    TEMPLATE_CHARACTER,
    TEMPLATE_CHARACTERS,
    LINE_CONTINUATION,
    BACKTICK,
    DOLLAR_SIGN,
    BACKSLASH,
    KEYWORD,
    LETTER_OR_DIGIT,
    SPACING,
    SPACING_NO_LB,
    NEXT_NOT_LB,
    LINE_TERMINATOR_SEQUENCE,
    PRIMARY_EXPRESSION,
    ARRAY_LITERAL,
    OBJECT_LITERAL,
    COVER_INITIALIZED_NAME,
    PROPERTY_DEFINITION,
    PAIR_PROPERTY,
    PROPERTY_NAME,
    MEMBER_EXPRESSION,
    SUPER_MEMBER_EXPRESSION,
    NEW_MEMBER_EXPRESSION,
    NEW_EXPRESSION,
    CALL_EXPRESSION,
    SIMPLE_CALL_EXPRESSION,
    ARGUMENTS,
    ARGUMENTS_LIST,
    LEFT_HAND_SIDE_EXPRESSION,
    POSTFIX_EXPRESSION,
    UNARY_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    ADDITIVE_EXPRESSION,
    SHIFT_EXPRESSION,
    RELATIONAL_EXPRESSION,
    RELATIONAL_EXPRESSION_NO_IN,
    EQUALITY_EXPRESSION,
    EQUALITY_EXPRESSION_NO_IN,
    BITWISE_AND_EXPRESSION,
    BITWISE_AND_EXPRESSION_NO_IN,
    BITWISE_XOR_EXPRESSION,
    BITWISE_XOR_EXPRESSION_NO_IN,
    BITWISE_OR_EXPRESSION,
    BITWISE_OR_EXPRESSION_NO_IN,
    LOGICAL_AND_EXPRESSION,
    LOGICAL_AND_EXPRESSION_NO_IN,
    LOGICAL_OR_EXPRESSION,
    LOGICAL_OR_EXPRESSION_NO_IN,
    CONDITIONAL_EXPRESSION,
    CONDITIONAL_EXPRESSION_NO_IN,
    ASSIGNMENT_EXPRESSION,
    ES6_ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_EXPRESSION_NO_IN,
    ES6_ASSIGNMENT_EXPRESSION_NO_IN,
    ASSIGNMENT_OPERATOR,
    EXPRESSION,
    EXPRESSION_NO_IN,
    ARROW_FUNCTION,
    ARROW_FUNCTION_NO_IN,
    ARROW_PARAMETERS,
    CONCISE_BODY,
    CONCISE_BODY_NO_IN,
    COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST,
    GENERATOR_EXPRESSION,
    CLASS_EXPRESSION,
    YIELD_EXPRESSION,
    YIELD_EXPRESSION_NO_IN,
    GENERATOR_COMPREHENSION,
    COMPREHENSION,
    COMPREHENSION_TAIL,
    COMPREHENSION_FOR,
    COMPREHENSION_IF,
    ARRAY_COMPREHENSION,
    ARRAY_INITIALIZER,
    ARRAY_INITIALIZER_ELEMENT,
    SPREAD_ELEMENT,
    ELISION,
    ELEMENT_LIST,
    BRACKET_EXPRESSION,
    OBJECT_PROPERTY_ACCESS,
    BINDING_REST_ELEMENT,
    SINGLE_NAME_BINDING,
    BINDING_ELEMENT,
    BINDING_PROPERTY,
    BINDING_ELISION_ELEMENT,
    BINDING_ELEMENT_LIST,
    BINDING_PROPERTY_LIST,
    ARRAY_BINDING_PATTERN,
    OBJECT_BINDING_PATTERN,
    BINDING_PATTERN,
    STATEMENT,
    BLOCK,
    STATEMENT_LIST,
    VARIABLE_STATEMENT,
    VARIABLE_DECLARATION_LIST,
    VARIABLE_DECLARATION_LIST_NO_IN,
    VARIABLE_DECLARATION,
    VARIABLE_DECLARATION_NO_IN,
    INITIALISER,
    INITIALISER_NO_IN,
    EMPTY_STATEMENT,
    EXPRESSION_STATEMENT,
    IF_STATEMENT,
    ELSE_CLAUSE,
    ITERATION_STATEMENT,
    DO_WHILE_STATEMENT,
    WHILE_STATEMENT,
    FOR_IN_STATEMENT,
    FOR_OF_STATEMENT,
    FOR_STATEMENT,
    OF,
    FOR_DECLARATION,
    FOR_BINDING,
    CONTINUE_STATEMENT,
    BREAK_STATEMENT,
    RETURN_STATEMENT,
    WITH_STATEMENT,
    SWITCH_STATEMENT,
    CASE_BLOCK,
    CASE_CLAUSES,
    CASE_CLAUSE,
    DEFAULT_CLAUSE,
    LABELLED_STATEMENT,
    THROW_STATEMENT,
    TRY_STATEMENT,
    CATCH,
    CATCH_PARAMETER,
    FINALLY,
    DEBUGGER_STATEMENT,
    DECLARATION,
    FUNCTION_DECLARATION,
    FUNCTION_EXPRESSION,
    FORMAL_PARAMETER_LIST,
    FORMAL_PARAMETER,
    REST_PARAMETER,
    FUNCTION_BODY,
    LEXICAL_DECLARATION,
    LEXICAL_DECLARATION_NO_IN,
    LET,
    LET_OR_CONST,
    BINDING_LIST,
    BINDING_LIST_NO_IN,
    LEXICAL_BINDING,
    LEXICAL_BINDING_NO_IN,
    BINDING_IDENTIFIER_INITIALISER,
    BINDING_IDENTIFIER_INITIALISER_NO_IN,
    BINDING_PATTERN_INITIALISER,
    BINDING_PATTERN_INITIALISER_NO_IN,
    BINDING_IDENTIFIER,
    IDENTIFIER_REFERENCE,
    COMPUTED_PROPERTY_NAME,
    LITERAL_PROPERTY_NAME,
    GENERATOR_METHOD,
    CLASS_DECLARATION,
    CLASS_TAIL,
    CLASS_HERITAGE,
    CLASS_BODY,
    CLASS_ELEMENT,
    STATIC_METHOD_DEFINITION,
    STATIC,
    METHOD_DEFINITION,
    METHOD,
    GETTER_METHOD,
    GET,
    SETTER_METHOD,
    PROPERTY_SET_PARAMETER_LIST,
    SET,
    MODULE_WORD,
    MODULE,
    MODULE_BODY,
    MODULE_ITEM,
    IMPORT_DECLARATION,
    EXPORT_DECLARATION,
    IMPORT_CLAUSE,
    FROM_CLAUSE,
    MODULE_IMPORT,
    NAMED_IMPORTS,
    IMPORTS_LIST,
    IMPORT_SPECIFIER,
    IMPORT_FROM,
    SIMPLE_IMPORT,
    FROM,
    AS,
    EXPORT_LIST_CLAUSE,
    EXPORT_ALL_CLAUSE,
    EXPORT_DEFAULT_CLAUSE,
    EXPORT_CLAUSE,
    EXPORT_LIST,
    EXPORT_SPECIFIER,
    GENERATOR_DECLARATION,
    SCRIPT,
    SCRIPT_BODY,
    SHEBANG;

    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return EcmaScriptGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule((GrammarRuleKey)IDENTIFIER_NAME).is((Object)SPACING, new Object[]{b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        b.rule((GrammarRuleKey)LITERAL).is(b.firstOf((Object)NULL_LITERAL, (Object)BOOLEAN_LITERAL, new Object[]{EcmaScriptTokenType.NUMERIC_LITERAL, STRING_LITERAL, EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL}));
        b.rule((GrammarRuleKey)NULL_LITERAL).is((Object)EcmaScriptKeyword.NULL);
        b.rule((GrammarRuleKey)BOOLEAN_LITERAL).is(b.firstOf((Object)EcmaScriptKeyword.TRUE, (Object)EcmaScriptKeyword.FALSE));
        EcmaScriptGrammar.lexical(b);
        EcmaScriptGrammar.expressions(b);
        EcmaScriptGrammar.statements(b);
        EcmaScriptGrammar.declarations(b);
        EcmaScriptGrammar.programs(b);
        b.setRootRule((GrammarRuleKey)SCRIPT);
        return b;
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), new Object[]{b.zeroOrMore(b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), new Object[]{b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"))})}).skip();
        b.rule((GrammarRuleKey)SPACING_NO_LB).is(b.zeroOrMore(b.firstOf(b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")), b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)"))))).skip();
        b.rule((GrammarRuleKey)NEXT_NOT_LB).is(b.nextNot(b.regexp("(?:/\\*[\\s\\S]*?\\*/|[\\n\\r\\u2028\\u2029])"))).skip();
        b.rule((GrammarRuleKey)LINE_TERMINATOR_SEQUENCE).is(b.skippedTrivia(b.regexp("(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)"))).skip();
        b.rule((GrammarRuleKey)EOS).is(b.firstOf(b.sequence((Object)SPACING, (Object)EcmaScriptPunctuator.SEMI), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOS_NO_LB).is(b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EcmaScriptPunctuator.SEMI}), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING_NO_LB, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOF).is(b.token((TokenType)GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule((GrammarRuleKey)EcmaScriptTokenType.IDENTIFIER).is((Object)SPACING, new Object[]{b.nextNot((Object)KEYWORD), b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        b.rule((GrammarRuleKey)EcmaScriptTokenType.NUMERIC_LITERAL).is((Object)SPACING, new Object[]{b.regexp("(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)")});
        b.rule((GrammarRuleKey)STRING_LITERAL).is((Object)SPACING, new Object[]{b.token((TokenType)GenericTokenType.LITERAL, b.regexp("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')"))});
        b.rule((GrammarRuleKey)EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL).is((Object)SPACING, new Object[]{b.regexp("\\/(?![*/])(?:[^\\\\\\[/&&[^\\r\\n\\u2028\\u2029]]|\\[(?:[^\\]\\\\&&[^\\r\\n\\u2028\\u2029]]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+")});
        b.rule((GrammarRuleKey)TEMPLATE_CHARACTERS).is(b.oneOrMore((Object)TEMPLATE_CHARACTER));
        b.rule((GrammarRuleKey)TEMPLATE_CHARACTER).is(b.firstOf(b.sequence((Object)DOLLAR_SIGN, b.nextNot((Object)EcmaScriptPunctuator.LCURLYBRACE)), b.sequence((Object)BACKSLASH, (Object)"\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}"), new Object[]{LINE_CONTINUATION, LINE_TERMINATOR_SEQUENCE, b.regexp("[^`\\$\\n\\r\\u2028\\u2029]")}));
        b.rule((GrammarRuleKey)LINE_CONTINUATION).is((Object)BACKSLASH, new Object[]{LINE_TERMINATOR_SEQUENCE});
        b.rule((GrammarRuleKey)BACKSLASH).is(EcmaScriptGrammar.word(b, "\\"));
        b.rule((GrammarRuleKey)BACKTICK).is(EcmaScriptGrammar.word(b, "`"));
        b.rule((GrammarRuleKey)DOLLAR_SIGN).is(EcmaScriptGrammar.word(b, "$"));
        EcmaScriptGrammar.punctuators(b);
        EcmaScriptGrammar.keywords(b);
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LCURLYBRACE, "{");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RCURLYBRACE, "}");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LPARENTHESIS, "(");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RPARENTHESIS, ")");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LBRACKET, "[");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RBRACKET, "]");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOUBLEARROW, "=>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOT, ".");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ELLIPSIS, "...");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SEMI, ";");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COMMA, ",");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LT, "<", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GT, ">", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LE, "<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GE, ">=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL, "==", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL, "!=", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL2, "===");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL2, "!==");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS, "+", b.nextNot(b.firstOf((Object)"+", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS, "-", b.nextNot(b.firstOf((Object)"-", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR, "*", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD, "%", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV, "/", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.INC, "++");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DEC, "--");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL, "<<", b.nextNot(b.firstOf((Object)"<", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR, ">>", b.nextNot(b.firstOf((Object)">", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR2, ">>>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND, "&", b.nextNot((Object)"&", new Object[]{"="}));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR, "|", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR, "^", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.BANG, "!", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.TILDA, "~");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ANDAND, "&&");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OROR, "||");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.QUERY, "?");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COLON, ":");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQU, "=", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS_EQU, "+=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS_EQU, "-=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV_EQU, "/=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR_EQU, "*=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD_EQU, "%=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL_EQU, "<<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU, ">>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU2, ">>>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND_EQU, "&=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR_EQU, "|=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR_EQU, "^=");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)LETTER_OR_DIGIT).is(b.regexp("\\p{javaJavaIdentifierPart}"));
        Object[] rest = new Object[EcmaScriptKeyword.values().length - 2];
        for (int i = 0; i < EcmaScriptKeyword.values().length; ++i) {
            EcmaScriptKeyword tokenType = EcmaScriptKeyword.values()[i];
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{tokenType.getValue(), b.nextNot((Object)LETTER_OR_DIGIT)});
            if (i <= 1) continue;
            rest[i - 2] = tokenType.getValue();
        }
        b.rule((GrammarRuleKey)KEYWORD).is(b.firstOf((Object)EcmaScriptKeyword.keywordValues()[0], (Object)EcmaScriptKeyword.keywordValues()[1], rest), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value});
            return;
        }
        throw new IllegalStateException(value);
    }

    private static Object word(LexerlessGrammarBuilder b, String value) {
        return b.sequence((Object)SPACING, b.token((TokenType)GenericTokenType.IDENTIFIER, (Object)value));
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value, element});
            return;
        }
        throw new IllegalStateException(value);
    }

    private static void expressions(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)PRIMARY_EXPRESSION).is(b.firstOf((Object)EcmaScriptKeyword.THIS, (Object)EcmaScriptTokenType.IDENTIFIER, new Object[]{LITERAL, ARRAY_INITIALIZER, OBJECT_LITERAL, FUNCTION_EXPRESSION, COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST, EcmaScriptGrammar.ecmascript6((Object)CLASS_EXPRESSION), EcmaScriptGrammar.ecmascript6((Object)GENERATOR_EXPRESSION), EcmaScriptGrammar.ecmascript6((Object)GENERATOR_COMPREHENSION), EcmaScriptGrammar.ecmascript6((Object)TEMPLATE_LITERAL)}));
        b.rule((GrammarRuleKey)TEMPLATE_LITERAL).is(b.firstOf((Object)NO_SUBSTITUTION_TEMPLATE, (Object)SUBSTITUTION_TEMPLATE));
        b.rule((GrammarRuleKey)NO_SUBSTITUTION_TEMPLATE).is((Object)BACKTICK, new Object[]{b.optional((Object)TEMPLATE_CHARACTERS), BACKTICK});
        b.rule((GrammarRuleKey)SUBSTITUTION_TEMPLATE).is((Object)TEMPLATE_HEAD, new Object[]{EXPRESSION, b.optional((Object)TEMPLATE_MIDDLE_LIST), TEMPLATE_TAIL});
        b.rule((GrammarRuleKey)TEMPLATE_HEAD).is((Object)BACKTICK, new Object[]{b.optional((Object)TEMPLATE_CHARACTERS), DOLLAR_SIGN, EcmaScriptPunctuator.LCURLYBRACE});
        b.rule((GrammarRuleKey)TEMPLATE_MIDDLE_LIST).is(b.oneOrMore((Object)TEMPLATE_MIDDLE, new Object[]{EXPRESSION}));
        b.rule((GrammarRuleKey)TEMPLATE_MIDDLE).is((Object)EcmaScriptPunctuator.RCURLYBRACE, new Object[]{b.optional((Object)TEMPLATE_CHARACTERS), DOLLAR_SIGN, EcmaScriptPunctuator.LCURLYBRACE});
        b.rule((GrammarRuleKey)TEMPLATE_TAIL).is((Object)EcmaScriptPunctuator.RCURLYBRACE, new Object[]{b.optional((Object)TEMPLATE_CHARACTERS), BACKTICK});
        b.rule((GrammarRuleKey)GENERATOR_COMPREHENSION).is((Object)EcmaScriptPunctuator.LPARENTHESIS, new Object[]{COMPREHENSION, EcmaScriptPunctuator.RPARENTHESIS});
        b.rule((GrammarRuleKey)COMPREHENSION).is((Object)COMPREHENSION_FOR, new Object[]{COMPREHENSION_TAIL});
        b.rule((GrammarRuleKey)COMPREHENSION_TAIL).is(b.zeroOrMore(b.firstOf((Object)COMPREHENSION_FOR, (Object)COMPREHENSION_IF)), new Object[]{ASSIGNMENT_EXPRESSION});
        b.rule((GrammarRuleKey)COMPREHENSION_FOR).is((Object)EcmaScriptKeyword.FOR, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, FOR_BINDING, OF, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS});
        b.rule((GrammarRuleKey)COMPREHENSION_IF).is((Object)EcmaScriptKeyword.IF, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS});
        b.rule((GrammarRuleKey)FOR_BINDING).is(b.firstOf((Object)BINDING_IDENTIFIER, (Object)BINDING_PATTERN));
        b.rule((GrammarRuleKey)BINDING_PATTERN).is(b.firstOf((Object)OBJECT_BINDING_PATTERN, (Object)ARRAY_BINDING_PATTERN));
        b.rule((GrammarRuleKey)OBJECT_BINDING_PATTERN).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)BINDING_PROPERTY_LIST, new Object[]{b.optional((Object)EcmaScriptPunctuator.COMMA)}), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)BINDING_PROPERTY_LIST).is((Object)BINDING_PROPERTY, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{BINDING_PROPERTY})});
        b.rule((GrammarRuleKey)BINDING_PROPERTY).is(b.firstOf(b.sequence((Object)PROPERTY_NAME, (Object)EcmaScriptPunctuator.COLON, new Object[]{BINDING_ELEMENT}), (Object)SINGLE_NAME_BINDING));
        b.rule((GrammarRuleKey)ARRAY_BINDING_PATTERN).is((Object)EcmaScriptPunctuator.LBRACKET, new Object[]{b.optional(b.firstOf(b.sequence((Object)BINDING_ELEMENT_LIST, b.optional((Object)EcmaScriptPunctuator.COMMA, new Object[]{b.optional((Object)ELISION), b.optional((Object)BINDING_REST_ELEMENT)})), b.sequence(b.optional((Object)ELISION), b.optional((Object)BINDING_REST_ELEMENT)))), EcmaScriptPunctuator.RBRACKET});
        b.rule((GrammarRuleKey)BINDING_ELEMENT_LIST).is((Object)BINDING_ELISION_ELEMENT, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{BINDING_ELISION_ELEMENT})});
        b.rule((GrammarRuleKey)BINDING_ELISION_ELEMENT).is(b.optional((Object)ELISION), new Object[]{BINDING_ELEMENT});
        b.rule((GrammarRuleKey)BINDING_ELEMENT).is(b.firstOf((Object)SINGLE_NAME_BINDING, b.sequence((Object)BINDING_PATTERN, b.optional((Object)INITIALISER))));
        b.rule((GrammarRuleKey)SINGLE_NAME_BINDING).is((Object)BINDING_IDENTIFIER, new Object[]{b.optional((Object)INITIALISER)});
        b.rule((GrammarRuleKey)BINDING_REST_ELEMENT).is((Object)EcmaScriptPunctuator.ELLIPSIS, new Object[]{BINDING_IDENTIFIER});
        b.rule((GrammarRuleKey)COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST).is((Object)EcmaScriptPunctuator.LPARENTHESIS, new Object[]{b.optional(b.firstOf((Object)REST_PARAMETER, b.sequence((Object)EXPRESSION, b.optional((Object)EcmaScriptPunctuator.COMMA, new Object[]{REST_PARAMETER})))), EcmaScriptPunctuator.RPARENTHESIS});
        b.rule((GrammarRuleKey)CLASS_EXPRESSION).is((Object)EcmaScriptKeyword.CLASS, new Object[]{b.optional((Object)BINDING_IDENTIFIER), CLASS_TAIL});
        b.rule((GrammarRuleKey)GENERATOR_EXPRESSION).is((Object)EcmaScriptKeyword.FUNCTION, new Object[]{EcmaScriptPunctuator.STAR, b.optional((Object)BINDING_IDENTIFIER), EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)ARRAY_INITIALIZER).is(b.firstOf((Object)ARRAY_LITERAL, EcmaScriptGrammar.ecmascript6((Object)ARRAY_COMPREHENSION)));
        b.rule((GrammarRuleKey)ARRAY_LITERAL).is((Object)EcmaScriptPunctuator.LBRACKET, new Object[]{b.optional(b.firstOf((Object)ELISION, b.sequence((Object)ELEMENT_LIST, b.optional((Object)EcmaScriptPunctuator.COMMA, new Object[]{b.optional((Object)ELISION)})))), EcmaScriptPunctuator.RBRACKET});
        b.rule((GrammarRuleKey)ELEMENT_LIST).is(b.optional((Object)ELISION), new Object[]{ARRAY_INITIALIZER_ELEMENT, b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{b.optional((Object)ELISION), ARRAY_INITIALIZER_ELEMENT})});
        b.rule((GrammarRuleKey)ARRAY_INITIALIZER_ELEMENT).is(b.firstOf((Object)SPREAD_ELEMENT, (Object)ASSIGNMENT_EXPRESSION));
        b.rule((GrammarRuleKey)ELISION).is(b.oneOrMore((Object)EcmaScriptPunctuator.COMMA));
        b.rule((GrammarRuleKey)SPREAD_ELEMENT).is((Object)EcmaScriptPunctuator.ELLIPSIS, new Object[]{ASSIGNMENT_EXPRESSION});
        b.rule((GrammarRuleKey)ARRAY_COMPREHENSION).is((Object)EcmaScriptPunctuator.LBRACKET, new Object[]{COMPREHENSION, EcmaScriptPunctuator.RBRACKET});
        b.rule((GrammarRuleKey)OBJECT_LITERAL).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)PROPERTY_DEFINITION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{PROPERTY_DEFINITION}), b.optional((Object)EcmaScriptPunctuator.COMMA)}), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)PROPERTY_DEFINITION).is(b.firstOf((Object)PAIR_PROPERTY, (Object)METHOD_DEFINITION, new Object[]{EcmaScriptGrammar.ecmascript6((Object)COVER_INITIALIZED_NAME)}));
        b.rule((GrammarRuleKey)COVER_INITIALIZED_NAME).is((Object)IDENTIFIER_REFERENCE, new Object[]{b.optional((Object)INITIALISER)});
        b.rule((GrammarRuleKey)PAIR_PROPERTY).is((Object)PROPERTY_NAME, new Object[]{EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION});
        b.rule((GrammarRuleKey)MEMBER_EXPRESSION).is(b.firstOf(EcmaScriptGrammar.ecmascript6((Object)SUPER_MEMBER_EXPRESSION), (Object)NEW_MEMBER_EXPRESSION, new Object[]{PRIMARY_EXPRESSION}), new Object[]{b.zeroOrMore(b.firstOf((Object)BRACKET_EXPRESSION, (Object)OBJECT_PROPERTY_ACCESS, new Object[]{EcmaScriptGrammar.ecmascript6((Object)TEMPLATE_LITERAL)}))});
        b.rule((GrammarRuleKey)SUPER_MEMBER_EXPRESSION).is(b.sequence((Object)EcmaScriptKeyword.SUPER, b.firstOf((Object)BRACKET_EXPRESSION, (Object)OBJECT_PROPERTY_ACCESS)));
        b.rule((GrammarRuleKey)NEW_MEMBER_EXPRESSION).is(b.sequence((Object)EcmaScriptKeyword.NEW, b.firstOf(EcmaScriptGrammar.ecmascript6((Object)EcmaScriptKeyword.SUPER), (Object)MEMBER_EXPRESSION), new Object[]{ARGUMENTS}));
        b.rule((GrammarRuleKey)NEW_EXPRESSION).is(b.firstOf((Object)MEMBER_EXPRESSION, EcmaScriptGrammar.ecmascript6(b.sequence((Object)EcmaScriptKeyword.NEW, (Object)EcmaScriptKeyword.SUPER)), new Object[]{b.sequence((Object)EcmaScriptKeyword.NEW, (Object)NEW_EXPRESSION)}));
        b.rule((GrammarRuleKey)CALL_EXPRESSION).is(b.firstOf((Object)SIMPLE_CALL_EXPRESSION, EcmaScriptGrammar.ecmascript6((Object)TEMPLATE_LITERAL)), new Object[]{b.zeroOrMore(b.firstOf((Object)ARGUMENTS, (Object)BRACKET_EXPRESSION, new Object[]{OBJECT_PROPERTY_ACCESS}))});
        b.rule((GrammarRuleKey)BRACKET_EXPRESSION).is((Object)EcmaScriptPunctuator.LBRACKET, new Object[]{EXPRESSION, EcmaScriptPunctuator.RBRACKET});
        b.rule((GrammarRuleKey)OBJECT_PROPERTY_ACCESS).is((Object)EcmaScriptPunctuator.DOT, new Object[]{IDENTIFIER_NAME});
        b.rule((GrammarRuleKey)SIMPLE_CALL_EXPRESSION).is(b.firstOf((Object)MEMBER_EXPRESSION, EcmaScriptGrammar.ecmascript6((Object)EcmaScriptKeyword.SUPER)), new Object[]{ARGUMENTS});
        b.rule((GrammarRuleKey)ARGUMENTS).is((Object)EcmaScriptPunctuator.LPARENTHESIS, new Object[]{b.optional((Object)ARGUMENTS_LIST), EcmaScriptPunctuator.RPARENTHESIS});
        b.rule((GrammarRuleKey)ARGUMENTS_LIST).is(b.optional((Object)EcmaScriptPunctuator.ELLIPSIS), new Object[]{ASSIGNMENT_EXPRESSION, b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{b.optional((Object)EcmaScriptPunctuator.ELLIPSIS), ASSIGNMENT_EXPRESSION})});
        b.rule((GrammarRuleKey)LEFT_HAND_SIDE_EXPRESSION).is(b.firstOf((Object)CALL_EXPRESSION, (Object)NEW_EXPRESSION));
        b.rule((GrammarRuleKey)POSTFIX_EXPRESSION).is((Object)LEFT_HAND_SIDE_EXPRESSION, new Object[]{b.optional((Object)SPACING_NO_LB, new Object[]{NEXT_NOT_LB, b.firstOf((Object)EcmaScriptPunctuator.INC, (Object)EcmaScriptPunctuator.DEC)})});
        b.rule((GrammarRuleKey)UNARY_EXPRESSION).is(b.firstOf((Object)POSTFIX_EXPRESSION, b.sequence((Object)EcmaScriptKeyword.DELETE, (Object)UNARY_EXPRESSION), new Object[]{b.sequence((Object)EcmaScriptKeyword.VOID, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptKeyword.TYPEOF, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.INC, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.DEC, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.PLUS, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.MINUS, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.TILDA, (Object)UNARY_EXPRESSION), b.sequence((Object)EcmaScriptPunctuator.BANG, (Object)UNARY_EXPRESSION)}));
        b.rule((GrammarRuleKey)MULTIPLICATIVE_EXPRESSION).is((Object)UNARY_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.STAR, (Object)EcmaScriptPunctuator.DIV, new Object[]{EcmaScriptPunctuator.MOD}), new Object[]{UNARY_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)ADDITIVE_EXPRESSION).is((Object)MULTIPLICATIVE_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.PLUS, (Object)EcmaScriptPunctuator.MINUS), new Object[]{MULTIPLICATIVE_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)SHIFT_EXPRESSION).is((Object)ADDITIVE_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.SL, (Object)EcmaScriptPunctuator.SR, new Object[]{EcmaScriptPunctuator.SR2}), new Object[]{ADDITIVE_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)RELATIONAL_EXPRESSION).is((Object)SHIFT_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.LT, (Object)EcmaScriptPunctuator.GT, new Object[]{EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF, EcmaScriptKeyword.IN}), new Object[]{SHIFT_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)RELATIONAL_EXPRESSION_NO_IN).is((Object)SHIFT_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.LT, (Object)EcmaScriptPunctuator.GT, new Object[]{EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF}), new Object[]{SHIFT_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)EQUALITY_EXPRESSION).is((Object)RELATIONAL_EXPRESSION, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.EQUAL, (Object)EcmaScriptPunctuator.NOTEQUAL, new Object[]{EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2}), new Object[]{RELATIONAL_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)EQUALITY_EXPRESSION_NO_IN).is((Object)RELATIONAL_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore(b.firstOf((Object)EcmaScriptPunctuator.EQUAL, (Object)EcmaScriptPunctuator.NOTEQUAL, new Object[]{EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2}), new Object[]{RELATIONAL_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_AND_EXPRESSION).is((Object)EQUALITY_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.AND, new Object[]{EQUALITY_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_AND_EXPRESSION_NO_IN).is((Object)EQUALITY_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.AND, new Object[]{EQUALITY_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_XOR_EXPRESSION).is((Object)BITWISE_AND_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.XOR, new Object[]{BITWISE_AND_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_XOR_EXPRESSION_NO_IN).is((Object)BITWISE_AND_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.XOR, new Object[]{BITWISE_AND_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_OR_EXPRESSION).is((Object)BITWISE_XOR_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OR, new Object[]{BITWISE_XOR_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)BITWISE_OR_EXPRESSION_NO_IN).is((Object)BITWISE_XOR_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OR, new Object[]{BITWISE_XOR_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_AND_EXPRESSION).is((Object)BITWISE_OR_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.ANDAND, new Object[]{BITWISE_OR_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_AND_EXPRESSION_NO_IN).is((Object)BITWISE_OR_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.ANDAND, new Object[]{BITWISE_OR_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_OR_EXPRESSION).is((Object)LOGICAL_AND_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OROR, new Object[]{LOGICAL_AND_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)LOGICAL_OR_EXPRESSION_NO_IN).is((Object)LOGICAL_AND_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.OROR, new Object[]{LOGICAL_AND_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)CONDITIONAL_EXPRESSION).is((Object)LOGICAL_OR_EXPRESSION, new Object[]{b.optional((Object)EcmaScriptPunctuator.QUERY, new Object[]{ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION})}).skipIfOneChild();
        b.rule((GrammarRuleKey)CONDITIONAL_EXPRESSION_NO_IN).is((Object)LOGICAL_OR_EXPRESSION_NO_IN, new Object[]{b.optional((Object)EcmaScriptPunctuator.QUERY, new Object[]{ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION_NO_IN})}).skipIfOneChild();
        b.rule((GrammarRuleKey)ES6_ASSIGNMENT_EXPRESSION).is(b.firstOf((Object)YIELD_EXPRESSION, (Object)ARROW_FUNCTION));
        b.rule((GrammarRuleKey)ES6_ASSIGNMENT_EXPRESSION_NO_IN).is(b.firstOf((Object)YIELD_EXPRESSION_NO_IN, (Object)ARROW_FUNCTION_NO_IN));
        b.rule((GrammarRuleKey)ASSIGNMENT_EXPRESSION).is(b.firstOf(b.sequence((Object)LEFT_HAND_SIDE_EXPRESSION, (Object)ASSIGNMENT_OPERATOR, new Object[]{ASSIGNMENT_EXPRESSION}), b.sequence((Object)CONDITIONAL_EXPRESSION, b.nextNot(b.regexp("(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]|//[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)*+"), new Object[]{"=>"})), new Object[]{EcmaScriptGrammar.ecmascript6((Object)ES6_ASSIGNMENT_EXPRESSION)})).skipIfOneChild();
        b.rule((GrammarRuleKey)ASSIGNMENT_EXPRESSION_NO_IN).is(b.firstOf(b.sequence((Object)LEFT_HAND_SIDE_EXPRESSION, (Object)ASSIGNMENT_OPERATOR, new Object[]{ASSIGNMENT_EXPRESSION_NO_IN}), EcmaScriptGrammar.ecmascript6((Object)ES6_ASSIGNMENT_EXPRESSION_NO_IN), new Object[]{CONDITIONAL_EXPRESSION_NO_IN})).skipIfOneChild();
        b.rule((GrammarRuleKey)ASSIGNMENT_OPERATOR).is(b.firstOf((Object)EcmaScriptPunctuator.EQU, (Object)EcmaScriptPunctuator.STAR_EQU, new Object[]{EcmaScriptPunctuator.DIV_EQU, EcmaScriptPunctuator.MOD_EQU, EcmaScriptPunctuator.PLUS_EQU, EcmaScriptPunctuator.MINUS_EQU, EcmaScriptPunctuator.SL_EQU, EcmaScriptPunctuator.SR_EQU, EcmaScriptPunctuator.SR_EQU2, EcmaScriptPunctuator.AND_EQU, EcmaScriptPunctuator.XOR_EQU, EcmaScriptPunctuator.OR_EQU})).skip();
        b.rule((GrammarRuleKey)YIELD_EXPRESSION).is((Object)EcmaScriptKeyword.YIELD, new Object[]{b.optional((Object)SPACING_NO_LB, new Object[]{NEXT_NOT_LB, b.optional((Object)EcmaScriptPunctuator.STAR), ASSIGNMENT_EXPRESSION})});
        b.rule((GrammarRuleKey)YIELD_EXPRESSION_NO_IN).is((Object)EcmaScriptKeyword.YIELD, new Object[]{b.optional((Object)SPACING_NO_LB, new Object[]{NEXT_NOT_LB, b.optional((Object)EcmaScriptPunctuator.STAR), ASSIGNMENT_EXPRESSION_NO_IN})});
        b.rule((GrammarRuleKey)ARROW_FUNCTION).is((Object)ARROW_PARAMETERS, new Object[]{SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptPunctuator.DOUBLEARROW, CONCISE_BODY});
        b.rule((GrammarRuleKey)ARROW_FUNCTION_NO_IN).is((Object)ARROW_PARAMETERS, new Object[]{SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptPunctuator.DOUBLEARROW, CONCISE_BODY_NO_IN});
        b.rule((GrammarRuleKey)ARROW_PARAMETERS).is(b.firstOf((Object)BINDING_IDENTIFIER, (Object)COVER_PARENTHESIZED_EXPRESSION_AND_ARROW_PARAMETER_LIST));
        b.rule((GrammarRuleKey)CONCISE_BODY).is(b.firstOf(b.sequence((Object)EcmaScriptPunctuator.LCURLYBRACE, (Object)FUNCTION_BODY, new Object[]{EcmaScriptPunctuator.RCURLYBRACE}), b.sequence(b.nextNot((Object)EcmaScriptPunctuator.LCURLYBRACE), (Object)ASSIGNMENT_EXPRESSION)));
        b.rule((GrammarRuleKey)CONCISE_BODY_NO_IN).is(b.firstOf(b.sequence((Object)EcmaScriptPunctuator.LPARENTHESIS, (Object)FUNCTION_BODY, new Object[]{EcmaScriptPunctuator.RCURLYBRACE}), b.sequence(b.nextNot((Object)EcmaScriptPunctuator.LCURLYBRACE), (Object)ASSIGNMENT_EXPRESSION_NO_IN)));
        b.rule((GrammarRuleKey)EXPRESSION).is((Object)ASSIGNMENT_EXPRESSION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{ASSIGNMENT_EXPRESSION})});
        b.rule((GrammarRuleKey)EXPRESSION_NO_IN).is((Object)ASSIGNMENT_EXPRESSION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{ASSIGNMENT_EXPRESSION_NO_IN})});
    }

    private static void statements(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)STATEMENT).is(b.firstOf((Object)BLOCK, (Object)VARIABLE_STATEMENT, new Object[]{EMPTY_STATEMENT, LABELLED_STATEMENT, EXPRESSION_STATEMENT, IF_STATEMENT, ITERATION_STATEMENT, CONTINUE_STATEMENT, BREAK_STATEMENT, RETURN_STATEMENT, WITH_STATEMENT, SWITCH_STATEMENT, THROW_STATEMENT, TRY_STATEMENT, DEBUGGER_STATEMENT}));
        b.rule((GrammarRuleKey)BLOCK).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)STATEMENT_LIST), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)STATEMENT_LIST).is(b.oneOrMore(b.firstOf(EcmaScriptGrammar.ecmascript6((Object)DECLARATION), (Object)STATEMENT)));
        b.rule((GrammarRuleKey)VARIABLE_STATEMENT).is((Object)EcmaScriptKeyword.VAR, new Object[]{VARIABLE_DECLARATION_LIST, EOS});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION_LIST).is((Object)VARIABLE_DECLARATION, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{VARIABLE_DECLARATION})});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION_LIST_NO_IN).is((Object)VARIABLE_DECLARATION_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{VARIABLE_DECLARATION_NO_IN})});
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION).is(b.firstOf((Object)BINDING_IDENTIFIER_INITIALISER, (Object)BINDING_PATTERN_INITIALISER));
        b.rule((GrammarRuleKey)VARIABLE_DECLARATION_NO_IN).is(b.firstOf((Object)BINDING_IDENTIFIER_INITIALISER_NO_IN, (Object)BINDING_PATTERN_INITIALISER_NO_IN));
        b.rule((GrammarRuleKey)INITIALISER).is((Object)EcmaScriptPunctuator.EQU, new Object[]{ASSIGNMENT_EXPRESSION});
        b.rule((GrammarRuleKey)INITIALISER_NO_IN).is((Object)EcmaScriptPunctuator.EQU, new Object[]{ASSIGNMENT_EXPRESSION_NO_IN});
        b.rule((GrammarRuleKey)EMPTY_STATEMENT).is((Object)EcmaScriptPunctuator.SEMI);
        b.rule((GrammarRuleKey)EXPRESSION_STATEMENT).is(b.nextNot(b.firstOf((Object)EcmaScriptPunctuator.LCURLYBRACE, (Object)EcmaScriptKeyword.FUNCTION)), new Object[]{EXPRESSION, EOS});
        b.rule((GrammarRuleKey)CONDITION).is((Object)EXPRESSION);
        b.rule((GrammarRuleKey)IF_STATEMENT).is((Object)EcmaScriptKeyword.IF, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT, b.optional((Object)ELSE_CLAUSE)});
        b.rule((GrammarRuleKey)ELSE_CLAUSE).is((Object)EcmaScriptKeyword.ELSE, new Object[]{STATEMENT});
        b.rule((GrammarRuleKey)ITERATION_STATEMENT).is(b.firstOf((Object)DO_WHILE_STATEMENT, (Object)WHILE_STATEMENT, new Object[]{FOR_IN_STATEMENT, EcmaScriptGrammar.ecmascript6((Object)FOR_OF_STATEMENT), FOR_STATEMENT}));
        b.rule((GrammarRuleKey)DO_WHILE_STATEMENT).is((Object)EcmaScriptKeyword.DO, new Object[]{STATEMENT, EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, EOS});
        b.rule((GrammarRuleKey)WHILE_STATEMENT).is((Object)EcmaScriptKeyword.WHILE, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)FOR_IN_STATEMENT).is((Object)EcmaScriptKeyword.FOR, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence((Object)EcmaScriptKeyword.VAR, b.firstOf((Object)VARIABLE_DECLARATION_LIST_NO_IN, EcmaScriptGrammar.ecmascript6((Object)FOR_BINDING))), b.sequence(EcmaScriptGrammar.ecmascript6(b.nextNot((Object)LET, new Object[]{EcmaScriptPunctuator.LBRACKET})), (Object)LEFT_HAND_SIDE_EXPRESSION), new Object[]{EcmaScriptGrammar.ecmascript6((Object)FOR_DECLARATION)}), EcmaScriptKeyword.IN, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)FOR_OF_STATEMENT).is((Object)EcmaScriptKeyword.FOR, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence((Object)EcmaScriptKeyword.VAR, (Object)FOR_BINDING), b.sequence(b.nextNot((Object)LET), (Object)LEFT_HAND_SIDE_EXPRESSION), new Object[]{FOR_DECLARATION}), OF, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)FOR_DECLARATION).is((Object)LET_OR_CONST, new Object[]{FOR_BINDING});
        b.rule((GrammarRuleKey)OF).is(EcmaScriptGrammar.word(b, "of"));
        b.rule((GrammarRuleKey)FOR_STATEMENT).is((Object)EcmaScriptKeyword.FOR, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence((Object)EcmaScriptKeyword.VAR, (Object)VARIABLE_DECLARATION_LIST_NO_IN), EcmaScriptGrammar.ecmascript6(b.sequence((Object)LEXICAL_DECLARATION_NO_IN, b.optional((Object)EXPRESSION_NO_IN))), new Object[]{b.optional(EcmaScriptGrammar.ecmascript6(b.nextNot((Object)LET, new Object[]{EcmaScriptPunctuator.LBRACKET})), new Object[]{EXPRESSION_NO_IN})}), EcmaScriptPunctuator.SEMI, b.optional((Object)CONDITION), EcmaScriptPunctuator.SEMI, b.optional((Object)EXPRESSION), EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)CONTINUE_STATEMENT).is((Object)EcmaScriptKeyword.CONTINUE, new Object[]{b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EcmaScriptTokenType.IDENTIFIER, EOS}), (Object)EOS_NO_LB)});
        b.rule((GrammarRuleKey)BREAK_STATEMENT).is((Object)EcmaScriptKeyword.BREAK, new Object[]{b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EcmaScriptTokenType.IDENTIFIER, EOS}), (Object)EOS_NO_LB)});
        b.rule((GrammarRuleKey)RETURN_STATEMENT).is((Object)EcmaScriptKeyword.RETURN, new Object[]{b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EXPRESSION, EOS}), (Object)EOS_NO_LB)});
        b.rule((GrammarRuleKey)WITH_STATEMENT).is((Object)EcmaScriptKeyword.WITH, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT});
        b.rule((GrammarRuleKey)SWITCH_STATEMENT).is((Object)EcmaScriptKeyword.SWITCH, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, CASE_BLOCK});
        b.rule((GrammarRuleKey)CASE_BLOCK).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)CASE_CLAUSES), b.optional((Object)DEFAULT_CLAUSE, new Object[]{b.optional((Object)CASE_CLAUSES)}), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)CASE_CLAUSES).is(b.oneOrMore((Object)CASE_CLAUSE));
        b.rule((GrammarRuleKey)CASE_CLAUSE).is((Object)EcmaScriptKeyword.CASE, new Object[]{EXPRESSION, EcmaScriptPunctuator.COLON, b.optional((Object)STATEMENT_LIST)});
        b.rule((GrammarRuleKey)DEFAULT_CLAUSE).is((Object)EcmaScriptKeyword.DEFAULT, new Object[]{EcmaScriptPunctuator.COLON, b.optional((Object)STATEMENT_LIST)});
        b.rule((GrammarRuleKey)LABELLED_STATEMENT).is((Object)EcmaScriptTokenType.IDENTIFIER, new Object[]{EcmaScriptPunctuator.COLON, STATEMENT});
        b.rule((GrammarRuleKey)THROW_STATEMENT).is((Object)EcmaScriptKeyword.THROW, new Object[]{SPACING_NO_LB, NEXT_NOT_LB, EXPRESSION, EOS});
        b.rule((GrammarRuleKey)TRY_STATEMENT).is((Object)EcmaScriptKeyword.TRY, new Object[]{BLOCK, b.firstOf(b.sequence((Object)CATCH, b.optional((Object)FINALLY)), (Object)FINALLY)});
        b.rule((GrammarRuleKey)CATCH).is((Object)EcmaScriptKeyword.CATCH, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, CATCH_PARAMETER, EcmaScriptPunctuator.RPARENTHESIS, BLOCK});
        b.rule((GrammarRuleKey)CATCH_PARAMETER).is(b.firstOf((Object)BINDING_IDENTIFIER, (Object)BINDING_PATTERN));
        b.rule((GrammarRuleKey)FINALLY).is((Object)EcmaScriptKeyword.FINALLY, new Object[]{BLOCK});
        b.rule((GrammarRuleKey)DEBUGGER_STATEMENT).is((Object)EcmaScriptKeyword.DEBUGGER, new Object[]{EOS});
    }

    private static void declarations(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)MODULE).is((Object)MODULE_BODY);
        b.rule((GrammarRuleKey)MODULE_BODY).is(b.oneOrMore((Object)MODULE_ITEM));
        b.rule((GrammarRuleKey)MODULE_ITEM).is(b.firstOf((Object)IMPORT_DECLARATION, (Object)EXPORT_DECLARATION, new Object[]{DECLARATION, STATEMENT}));
        b.rule((GrammarRuleKey)EXPORT_DECLARATION).is((Object)EcmaScriptKeyword.EXPORT, new Object[]{b.firstOf((Object)EXPORT_ALL_CLAUSE, (Object)EXPORT_LIST_CLAUSE, new Object[]{VARIABLE_STATEMENT, DECLARATION, EXPORT_DEFAULT_CLAUSE})});
        b.rule((GrammarRuleKey)EXPORT_ALL_CLAUSE).is((Object)EcmaScriptPunctuator.STAR, new Object[]{FROM_CLAUSE, EOS});
        b.rule((GrammarRuleKey)EXPORT_DEFAULT_CLAUSE).is((Object)EcmaScriptKeyword.DEFAULT, new Object[]{ASSIGNMENT_EXPRESSION, EOS});
        b.rule((GrammarRuleKey)EXPORT_LIST_CLAUSE).is((Object)EXPORT_CLAUSE, new Object[]{b.optional((Object)FROM_CLAUSE), EOS});
        b.rule((GrammarRuleKey)EXPORT_CLAUSE).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)EXPORT_LIST, new Object[]{b.optional((Object)EcmaScriptPunctuator.COMMA)}), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)EXPORT_LIST).is((Object)EXPORT_SPECIFIER, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{EXPORT_SPECIFIER})});
        b.rule((GrammarRuleKey)EXPORT_SPECIFIER).is(b.firstOf((Object)IDENTIFIER_REFERENCE, (Object)IDENTIFIER_NAME), new Object[]{b.optional((Object)AS, new Object[]{IDENTIFIER_NAME})});
        b.rule((GrammarRuleKey)IMPORT_DECLARATION).is(b.firstOf((Object)MODULE_IMPORT, (Object)SIMPLE_IMPORT, new Object[]{IMPORT_FROM}));
        b.rule((GrammarRuleKey)MODULE_IMPORT).is((Object)MODULE_WORD, new Object[]{SPACING_NO_LB, NEXT_NOT_LB, BINDING_IDENTIFIER, FROM_CLAUSE, EOS});
        b.rule((GrammarRuleKey)MODULE_WORD).is(EcmaScriptGrammar.word(b, "module"));
        b.rule((GrammarRuleKey)SIMPLE_IMPORT).is((Object)EcmaScriptKeyword.IMPORT, new Object[]{STRING_LITERAL, EOS});
        b.rule((GrammarRuleKey)IMPORT_FROM).is((Object)EcmaScriptKeyword.IMPORT, new Object[]{IMPORT_CLAUSE, FROM_CLAUSE, EOS});
        b.rule((GrammarRuleKey)FROM_CLAUSE).is((Object)FROM, new Object[]{STRING_LITERAL});
        b.rule((GrammarRuleKey)FROM).is(EcmaScriptGrammar.word(b, "from"));
        b.rule((GrammarRuleKey)IMPORT_CLAUSE).is(b.firstOf((Object)NAMED_IMPORTS, b.sequence((Object)BINDING_IDENTIFIER, b.optional((Object)EcmaScriptPunctuator.COMMA, new Object[]{NAMED_IMPORTS}))));
        b.rule((GrammarRuleKey)NAMED_IMPORTS).is((Object)EcmaScriptPunctuator.LCURLYBRACE, new Object[]{b.optional((Object)IMPORTS_LIST, new Object[]{b.optional((Object)EcmaScriptPunctuator.COMMA)}), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)IMPORTS_LIST).is((Object)IMPORT_SPECIFIER, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{IMPORT_SPECIFIER})});
        b.rule((GrammarRuleKey)IMPORT_SPECIFIER).is(b.optional((Object)IDENTIFIER_NAME, new Object[]{AS}), new Object[]{BINDING_IDENTIFIER});
        b.rule((GrammarRuleKey)AS).is(EcmaScriptGrammar.word(b, "as"));
        b.rule((GrammarRuleKey)DECLARATION).is(b.firstOf((Object)FUNCTION_DECLARATION, EcmaScriptGrammar.ecmascript6((Object)GENERATOR_DECLARATION), new Object[]{EcmaScriptGrammar.ecmascript6((Object)CLASS_DECLARATION), EcmaScriptGrammar.ecmascript6((Object)LEXICAL_DECLARATION)}));
        b.rule((GrammarRuleKey)FUNCTION_DECLARATION).is((Object)EcmaScriptKeyword.FUNCTION, new Object[]{EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)FUNCTION_EXPRESSION).is((Object)EcmaScriptKeyword.FUNCTION, new Object[]{b.optional((Object)EcmaScriptTokenType.IDENTIFIER), EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)FORMAL_PARAMETER_LIST).is(b.firstOf(b.sequence((Object)FORMAL_PARAMETER, b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{FORMAL_PARAMETER}), new Object[]{EcmaScriptGrammar.ecmascript6(b.optional((Object)EcmaScriptPunctuator.COMMA, new Object[]{REST_PARAMETER}))}), EcmaScriptGrammar.ecmascript6((Object)REST_PARAMETER)));
        b.rule((GrammarRuleKey)REST_PARAMETER).is((Object)BINDING_REST_ELEMENT);
        b.rule((GrammarRuleKey)FORMAL_PARAMETER).is((Object)BINDING_ELEMENT);
        b.rule((GrammarRuleKey)FUNCTION_BODY).is(b.optional((Object)STATEMENT_LIST));
        b.rule((GrammarRuleKey)GENERATOR_DECLARATION).is((Object)EcmaScriptKeyword.FUNCTION, new Object[]{EcmaScriptPunctuator.STAR, BINDING_IDENTIFIER, EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)LEXICAL_DECLARATION).is((Object)LET_OR_CONST, new Object[]{BINDING_LIST});
        b.rule((GrammarRuleKey)LEXICAL_DECLARATION_NO_IN).is((Object)LET_OR_CONST, new Object[]{BINDING_LIST_NO_IN});
        b.rule((GrammarRuleKey)LET_OR_CONST).is(b.firstOf((Object)LET, (Object)EcmaScriptKeyword.CONST));
        b.rule((GrammarRuleKey)LET).is(EcmaScriptGrammar.word(b, "let"));
        b.rule((GrammarRuleKey)BINDING_LIST).is((Object)LEXICAL_BINDING, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{LEXICAL_BINDING})});
        b.rule((GrammarRuleKey)BINDING_LIST_NO_IN).is((Object)LEXICAL_BINDING_NO_IN, new Object[]{b.zeroOrMore((Object)EcmaScriptPunctuator.COMMA, new Object[]{LEXICAL_BINDING_NO_IN})});
        b.rule((GrammarRuleKey)LEXICAL_BINDING).is(b.firstOf((Object)BINDING_IDENTIFIER_INITIALISER, (Object)BINDING_PATTERN_INITIALISER));
        b.rule((GrammarRuleKey)LEXICAL_BINDING_NO_IN).is(b.firstOf((Object)BINDING_IDENTIFIER_INITIALISER_NO_IN, (Object)BINDING_PATTERN_INITIALISER_NO_IN));
        b.rule((GrammarRuleKey)BINDING_IDENTIFIER_INITIALISER).is((Object)BINDING_IDENTIFIER, new Object[]{b.optional((Object)INITIALISER)});
        b.rule((GrammarRuleKey)BINDING_IDENTIFIER_INITIALISER_NO_IN).is((Object)BINDING_IDENTIFIER, new Object[]{b.optional((Object)INITIALISER_NO_IN)});
        b.rule((GrammarRuleKey)BINDING_PATTERN_INITIALISER).is((Object)BINDING_PATTERN, new Object[]{INITIALISER});
        b.rule((GrammarRuleKey)BINDING_PATTERN_INITIALISER_NO_IN).is((Object)BINDING_PATTERN, new Object[]{INITIALISER_NO_IN});
        b.rule((GrammarRuleKey)BINDING_IDENTIFIER).is(b.firstOf(EcmaScriptGrammar.ecmascript6((Object)EcmaScriptKeyword.DEFAULT), EcmaScriptGrammar.ecmascript6((Object)EcmaScriptKeyword.YIELD), new Object[]{EcmaScriptTokenType.IDENTIFIER}));
        b.rule((GrammarRuleKey)IDENTIFIER_REFERENCE).is(b.firstOf((Object)EcmaScriptKeyword.YIELD, (Object)EcmaScriptTokenType.IDENTIFIER));
        b.rule((GrammarRuleKey)CLASS_DECLARATION).is((Object)EcmaScriptKeyword.CLASS, new Object[]{BINDING_IDENTIFIER, CLASS_TAIL});
        b.rule((GrammarRuleKey)CLASS_TAIL).is(b.optional((Object)CLASS_HERITAGE), new Object[]{EcmaScriptPunctuator.LCURLYBRACE, b.optional((Object)CLASS_BODY), EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)CLASS_HERITAGE).is((Object)EcmaScriptKeyword.EXTENDS, new Object[]{LEFT_HAND_SIDE_EXPRESSION});
        b.rule((GrammarRuleKey)CLASS_BODY).is(b.oneOrMore((Object)CLASS_ELEMENT));
        b.rule((GrammarRuleKey)CLASS_ELEMENT).is(b.firstOf((Object)STATIC_METHOD_DEFINITION, (Object)METHOD_DEFINITION, new Object[]{EcmaScriptPunctuator.SEMI}));
        b.rule((GrammarRuleKey)STATIC_METHOD_DEFINITION).is((Object)STATIC, new Object[]{METHOD_DEFINITION});
        b.rule((GrammarRuleKey)STATIC).is(EcmaScriptGrammar.word(b, "static"));
        b.rule((GrammarRuleKey)METHOD_DEFINITION).is(b.firstOf(EcmaScriptGrammar.ecmascript6((Object)METHOD), EcmaScriptGrammar.ecmascript6((Object)GENERATOR_METHOD), new Object[]{GETTER_METHOD, SETTER_METHOD}));
        b.rule((GrammarRuleKey)METHOD).is((Object)PROPERTY_NAME, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)SETTER_METHOD).is(b.sequence((Object)SET, (Object)PROPERTY_NAME, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, PROPERTY_SET_PARAMETER_LIST, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE}));
        b.rule((GrammarRuleKey)PROPERTY_SET_PARAMETER_LIST).is((Object)FORMAL_PARAMETER);
        b.rule((GrammarRuleKey)SET).is(EcmaScriptGrammar.word(b, "set"));
        b.rule((GrammarRuleKey)GETTER_METHOD).is(b.sequence((Object)GET, (Object)PROPERTY_NAME, new Object[]{EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE}));
        b.rule((GrammarRuleKey)GET).is(EcmaScriptGrammar.word(b, "get"));
        b.rule((GrammarRuleKey)GENERATOR_METHOD).is((Object)EcmaScriptPunctuator.STAR, new Object[]{PROPERTY_NAME, EcmaScriptPunctuator.LPARENTHESIS, b.optional((Object)FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE});
        b.rule((GrammarRuleKey)PROPERTY_NAME).is(b.firstOf((Object)LITERAL_PROPERTY_NAME, EcmaScriptGrammar.ecmascript6((Object)COMPUTED_PROPERTY_NAME)));
        b.rule((GrammarRuleKey)LITERAL_PROPERTY_NAME).is(b.firstOf((Object)IDENTIFIER_NAME, (Object)STRING_LITERAL, new Object[]{EcmaScriptTokenType.NUMERIC_LITERAL}));
        b.rule((GrammarRuleKey)COMPUTED_PROPERTY_NAME).is((Object)EcmaScriptPunctuator.LBRACKET, new Object[]{ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.RBRACKET});
    }

    private static void programs(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)SCRIPT).is(b.optional((Object)SHEBANG), new Object[]{b.optional((Object)MODULE_BODY), SPACING, EOF});
        b.rule((GrammarRuleKey)SHEBANG).is((Object)"#!", new Object[]{b.regexp("[^\\n\\r]*+")}).skip();
    }

    private static Object ecmascript6(Object object) {
        return object;
    }

    private EcmaScriptGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

