/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.parser;

import com.google.common.base.Throwables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.lang.reflect.Field;
import javax.annotation.Nullable;

public class AstNodeReflector {
    private static final Field TOKEN_FIELD = AstNodeReflector.getAstNodeField("token");
    private static final Field CHILD_INDEX_FIELD = AstNodeReflector.getAstNodeField("childIndex");
    private static final Field PARENT_FIELD = AstNodeReflector.getAstNodeField("parent");

    private AstNodeReflector() {
    }

    public static void setToken(AstNode astNode, @Nullable Token token) {
        AstNodeReflector.setField(TOKEN_FIELD, astNode, token);
    }

    public static void setChildIndex(AstNode astNode, int childIndex) {
        AstNodeReflector.setField(CHILD_INDEX_FIELD, astNode, childIndex);
    }

    public static void setParent(AstNode astNode, @Nullable AstNode parent) {
        AstNodeReflector.setField(PARENT_FIELD, astNode, parent);
    }

    private static Field getAstNodeField(String name) {
        try {
            Field field = AstNode.class.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void setField(Field field, Object instance, Object value) {
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

