/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="PreIncrementDecrement", priority=Priority.MAJOR, name="Pre-increment and pre-decrement should not be used", tags={"bug"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class PreIncrementDecrementCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "PreIncrementDecrement";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.FACTOR});
    }

    public void visitNode(AstNode astNode) {
        List children = astNode.getChildren();
        AstNode firstChild = (AstNode)children.get(0);
        AstNode secondChild = (AstNode)children.get(1);
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.PLUS}) && secondChild.getFirstChild().is(new AstNodeType[]{PythonPunctuator.PLUS})) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement doesn't produce the expected result, replace use of non-existent pre-increment operator", astNode, new Object[0]);
        }
        if (firstChild.is(new AstNodeType[]{PythonPunctuator.MINUS}) && secondChild.getFirstChild().is(new AstNodeType[]{PythonPunctuator.MINUS})) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement doesn't produce the expected result, replace use of non-existent pre-decrement operator", astNode, new Object[0]);
        }
    }
}

