/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Grammar;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.python.api.PythonGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S1763", priority=Priority.MAJOR, name="Jump statements should not be followed by other statements", tags={"unused", "cert", "cwe", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
@ActivatedByDefault
public class AfterJumpStatementCheck
extends SquidCheck<Grammar> {
    public static final String CHECK_KEY = "S1763";
    private static final String MESSAGE = "Remove the code after this \"%s\".";

    public void init() {
        this.subscribeTo(new AstNodeType[]{PythonGrammar.RETURN_STMT, PythonGrammar.RAISE_STMT, PythonGrammar.BREAK_STMT, PythonGrammar.CONTINUE_STMT});
    }

    public void visitNode(AstNode node) {
        AstNode simpleStatement = node.getParent();
        AstNode nextSibling = simpleStatement.getNextSibling();
        if (nextSibling != null && nextSibling.getNextSibling() != null) {
            this.raiseIssue(node);
            return;
        }
        AstNode stmtList = simpleStatement.getParent();
        if (stmtList.getParent().is(new AstNodeType[]{PythonGrammar.STATEMENT}) && (nextSibling = stmtList.getParent().getNextSibling()) != null && nextSibling.getNextSibling() != null) {
            this.raiseIssue(node);
        }
    }

    private void raiseIssue(AstNode node) {
        this.getContext().createLineViolation((CodeCheck)this, String.format(MESSAGE, node.getTokenValue()), node, new Object[0]);
    }
}

