/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;

@Rule(key="S139", priority=Priority.INFO, name="Comments should not be located at the end of lines of code", tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingCommentCheck
extends SquidCheck<Grammar>
implements AstAndTokenVisitor {
    public static final String CHECK_KEY = "S139";
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^#\\s*+[^\\s]++$";
    @RuleProperty(key="legalTrailingCommentPattern", defaultValue="^#\\s*+[^\\s]++$")
    public String legalCommentPattern = "^#\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    public void visitFile(AstNode astNode) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment;
            if (!trivia.isComment() || trivia.getToken().getLine() != this.previousTokenLine || this.pattern.matcher(comment = trivia.getToken().getValue()).matches()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Move this trailing comment on the previous empty line.", this.previousTokenLine, new Object[0]);
        }
        this.previousTokenLine = token.getLine();
    }
}

