/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.RecognitionExceptionListener;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.LexerException;
import com.sonar.sslr.impl.ParsingStackTrace;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.events.ExtendedStackTrace;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.impl.matcher.GrammarFunctions;
import com.sonar.sslr.impl.matcher.RuleDefinition;
import java.io.File;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parser<GRAMMAR extends Grammar> {
    private RuleDefinition rootRule;
    private ParsingState parsingState;
    private final Lexer lexer;
    private final GRAMMAR grammar;
    private Set<RecognitionExceptionListener> listeners = new HashSet<RecognitionExceptionListener>();
    private ParsingEventListener[] parsingEventListeners;
    private final ExtendedStackTrace extendedStackTrace;

    private Parser(Builder<GRAMMAR> builder) {
        this.lexer = ((Builder)builder).lexer;
        this.grammar = ((Builder)builder).grammar;
        this.listeners = ((Builder)builder).listeners;
        this.extendedStackTrace = ((Builder)builder).extendedStackTrace;
        if (this.extendedStackTrace != null) {
            this.parsingEventListeners = ((Builder)builder).parsingEventListeners.toArray(new ParsingEventListener[((Builder)builder).parsingEventListeners.size() + 1]);
            this.parsingEventListeners[this.parsingEventListeners.length - 1] = this.extendedStackTrace;
        } else {
            this.parsingEventListeners = ((Builder)builder).parsingEventListeners.toArray(new ParsingEventListener[((Builder)builder).parsingEventListeners.size()]);
        }
        GrammarFunctions.resetCache();
        this.rootRule = (RuleDefinition)((Grammar)this.grammar).getRootRule();
    }

    public void printStackTrace(PrintStream stream) {
        stream.append(ParsingStackTrace.generateFullStackTrace(this.getParsingState()));
    }

    public void addListener(RecognitionExceptionListener listerner) {
        this.listeners.add(listerner);
    }

    public AstNode parse(File file) {
        this.fireBeginLexEvent();
        try {
            this.lexer.lex(file);
        }
        catch (LexerException e) {
            throw new RecognitionException(e);
        }
        finally {
            this.fireEndLexEvent();
        }
        return this.parse(this.lexer.getTokens());
    }

    public AstNode parse(String source) {
        this.fireBeginLexEvent();
        try {
            this.lexer.lex(source);
        }
        catch (LexerException e) {
            throw new RecognitionException(e);
        }
        finally {
            this.fireEndLexEvent();
        }
        return this.parse(this.lexer.getTokens());
    }

    public AstNode parse(List<Token> tokens) {
        this.fireBeginParseEvent();
        try {
            this.parsingState = new ParsingState(tokens);
            this.parsingState.addListeners(this.listeners.toArray(new RecognitionExceptionListener[this.listeners.size()]));
            this.parsingState.parsingEventListeners = this.parsingEventListeners;
            this.parsingState.extendedStackTrace = this.extendedStackTrace;
            AstNode astNode = this.rootRule.getRule().match(this.parsingState);
            return astNode;
        }
        catch (BacktrackingEvent e) {
            throw this.extendedStackTrace == null ? new RecognitionException(this.parsingState, true) : new RecognitionException(this.extendedStackTrace, true);
        }
        catch (StackOverflowError e) {
            throw new RecognitionException("The grammar seems to contain a left recursion which is not compatible with LL(*) parser.", this.parsingState, true, e);
        }
        finally {
            this.fireEndParseEvent();
        }
    }

    private void fireBeginLexEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.beginLex();
            }
        }
    }

    private void fireEndLexEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.endLex();
            }
        }
    }

    private void fireEndParseEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.endParse();
            }
        }
    }

    private void fireBeginParseEvent() {
        if (this.parsingEventListeners != null) {
            for (ParsingEventListener listener : this.parsingEventListeners) {
                listener.beginParse();
            }
        }
    }

    public ParsingState getParsingState() {
        return this.parsingState;
    }

    public GRAMMAR getGrammar() {
        return this.grammar;
    }

    public RuleDefinition getRootRule() {
        return this.rootRule;
    }

    public void setRootRule(Rule rootRule) {
        this.rootRule = (RuleDefinition)rootRule;
    }

    public static <GRAMMAR extends Grammar> Builder<GRAMMAR> builder(GRAMMAR grammar) {
        return new Builder(grammar, null);
    }

    public static <GRAMMAR extends Grammar> Builder<GRAMMAR> builder(Parser<GRAMMAR> parser) {
        return new Builder(parser);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder<GRAMMAR extends Grammar> {
        private Lexer lexer;
        private final GRAMMAR grammar;
        private final Set<ParsingEventListener> parsingEventListeners = new HashSet<ParsingEventListener>();
        private final Set<RecognitionExceptionListener> listeners = new HashSet<RecognitionExceptionListener>();
        private ExtendedStackTrace extendedStackTrace;

        private Builder(GRAMMAR grammar) {
            this.grammar = grammar;
        }

        private Builder(Parser<GRAMMAR> parser) {
            this.lexer = ((Parser)parser).lexer;
            this.grammar = ((Parser)parser).grammar;
            this.setParsingEventListeners(((Parser)parser).parsingEventListeners);
            this.setRecognictionExceptionListener(((Parser)parser).listeners.toArray(new RecognitionExceptionListener[((Parser)parser).listeners.size()]));
            this.extendedStackTrace = ((Parser)parser).extendedStackTrace;
        }

        public Parser<GRAMMAR> build() {
            return new Parser(this);
        }

        public Builder<GRAMMAR> withLexer(Lexer lexer) {
            this.lexer = lexer;
            return this;
        }

        public Builder<GRAMMAR> setParsingEventListeners(ParsingEventListener ... parsingEventListeners) {
            this.parsingEventListeners.clear();
            this.addParsingEventListeners(parsingEventListeners);
            return this;
        }

        public Builder<GRAMMAR> addParsingEventListeners(ParsingEventListener ... parsingEventListeners) {
            for (ParsingEventListener parsingEventListener : parsingEventListeners) {
                this.parsingEventListeners.add(parsingEventListener);
            }
            return this;
        }

        public Builder<GRAMMAR> setRecognictionExceptionListener(RecognitionExceptionListener ... listeners) {
            this.listeners.clear();
            this.addRecognictionExceptionListeners(listeners);
            return this;
        }

        public Builder<GRAMMAR> addRecognictionExceptionListeners(RecognitionExceptionListener ... listeners) {
            for (RecognitionExceptionListener listener : listeners) {
                this.listeners.add(listener);
            }
            return this;
        }

        public Builder<GRAMMAR> setExtendedStackTrace(ExtendedStackTrace extendedStackTrace) {
            this.extendedStackTrace = extendedStackTrace;
            return this;
        }

        /* synthetic */ Builder(Grammar x0, 1 x1) {
            this(x0);
        }
    }
}

