/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.channel;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import java.util.Arrays;
import java.util.Comparator;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PunctuatorChannel
extends Channel<Lexer> {
    private final TokenType[] sortedPunctuators;
    private final char[][] sortedPunctuatorsChars;
    private final Token.Builder tokenBuilder = Token.builder();

    public PunctuatorChannel(TokenType ... punctuators) {
        this.sortedPunctuators = punctuators;
        Arrays.sort(this.sortedPunctuators, new PunctuatorComparator());
        this.sortedPunctuatorsChars = new char[this.sortedPunctuators.length][];
        for (int i = 0; i < this.sortedPunctuators.length; ++i) {
            this.sortedPunctuatorsChars[i] = this.sortedPunctuators[i].getValue().toCharArray();
        }
    }

    @Override
    public boolean consume(CodeReader code, Lexer lexer) {
        for (int i = 0; i < this.sortedPunctuators.length; ++i) {
            if (code.peek() != this.sortedPunctuatorsChars[i][0] || !Arrays.equals(code.peek(this.sortedPunctuatorsChars[i].length), this.sortedPunctuatorsChars[i])) continue;
            Token token = this.tokenBuilder.setType(this.sortedPunctuators[i]).setValueAndOriginalValue(this.sortedPunctuators[i].getValue()).setURI(lexer.getURI()).setLine(code.getLinePosition()).setColumn(code.getColumnPosition()).build();
            lexer.addToken(token);
            for (int j = 0; j < this.sortedPunctuatorsChars[i].length; ++j) {
                code.pop();
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PunctuatorComparator
    implements Comparator<TokenType> {
        private PunctuatorComparator() {
        }

        @Override
        public int compare(TokenType a, TokenType b) {
            if (a.getValue().length() == b.getValue().length()) {
                return 0;
            }
            return a.getValue().length() > b.getValue().length() ? -1 : 1;
        }
    }
}

