/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.matcher.GrammarFunctions;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.StandardMatcher;

public final class RuleMatcher
extends StandardMatcher {
    private final String name;
    private boolean recoveryRule = false;
    private AstNodeType astNodeType;

    public RuleMatcher(String name) {
        super(new Matcher[0]);
        this.name = name;
    }

    protected Matcher.MatchResult doMatch(ParsingState parsingState) {
        this.enterEvent(parsingState);
        int startIndex = parsingState.lexerIndex;
        if (this.children.length == 0) {
            throw new IllegalStateException("The rule '" + this.name + "' hasn't beed defined.");
        }
        Matcher.MatchResult matchResult = this.children[0].doMatch(parsingState);
        if (this.recoveryRule) {
            RecognitionException recognitionException;
            RecognitionException recognitionException2 = recognitionException = parsingState.extendedStackTrace == null ? new RecognitionException(parsingState, false) : new RecognitionException(parsingState.extendedStackTrace, false);
            if (matchResult.isMatching()) {
                parsingState.lexerIndex = startIndex;
                parsingState.notifyListeners(recognitionException);
                parsingState.lexerIndex = matchResult.getToIndex();
            }
        }
        if (!matchResult.isMatching()) {
            this.exitWithoutMatchEvent(parsingState);
            return Matcher.MatchResult.fail(parsingState, startIndex);
        }
        AstNode childNode = matchResult.getAstNode();
        AstNode astNode = new AstNode(this.astNodeType, this.name, parsingState.peekTokenIfExists(startIndex, this.children[0]));
        astNode.addChild(childNode);
        this.exitWithMatchEvent(parsingState, astNode);
        return Matcher.MatchResult.succeed(parsingState, startIndex, astNode);
    }

    void memoizeMatches() {
        if (this.children.length == 0) {
            return;
        }
        this.children[0] = GrammarFunctions.Advanced.memoizeMatches(this.children[0]);
    }

    public void setNodeType(AstNodeType astNodeType) {
        this.astNodeType = astNodeType;
    }

    public String getName() {
        return this.name;
    }

    public void recoveryRule() {
        this.recoveryRule = true;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

