/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.configuration.Configuration;
import org.apache.tools.ant.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PythonReportSensor
implements Sensor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Configuration conf = null;

    public PythonReportSensor(Configuration conf) {
        this.conf = conf;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "py".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        try {
            List<File> reports = this.getReports(this.conf, project.getFileSystem().getBasedir().getPath(), this.reportPathKey(), this.defaultReportPath());
            for (File report : reports) {
                this.log.info("Processing report '{}'", (Object)report);
                this.processReport(project, context, report);
            }
            if (reports.isEmpty()) {
                this.handleNoReportsCase(context);
            }
        }
        catch (XMLStreamException e) {
            String msg = "Cannot feed the data into sonar, details: '" + e + "'";
            throw new SonarException(msg, (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected List<File> getReports(Configuration conf, String baseDirPath, String reportPathPropertyKey, String defaultReportPath) {
        String reportPath = conf.getString(reportPathPropertyKey, null);
        if (reportPath == null) {
            reportPath = defaultReportPath;
        }
        this.log.debug("Using pattern '{}' to find reports", (Object)reportPath);
        DirectoryScanner scanner = new DirectoryScanner();
        String[] includes = new String[]{reportPath};
        scanner.setIncludes(includes);
        scanner.setBasedir(new File(baseDirPath));
        scanner.scan();
        String[] relPaths = scanner.getIncludedFiles();
        ArrayList<File> reports = new ArrayList<File>();
        for (String relPath : relPaths) {
            reports.add(new File(baseDirPath, relPath));
        }
        return reports;
    }

    protected void processReport(Project project, SensorContext context, File report) throws XMLStreamException {
    }

    protected void handleNoReportsCase(SensorContext context) {
    }

    protected String reportPathKey() {
        return "";
    }

    protected String defaultReportPath() {
        return "";
    }
}

