/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputPath;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.python.PythonReportSensor;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintReportParser;

@Properties(value={@Property(key="sonar.python.pylint.reportPath", defaultValue="", name="Pylint's reports", description="Path to Pylint's report file, relative to projects root", global=false, project=true)})
public class PylintImportSensor
extends PythonReportSensor {
    public static final String REPORT_PATH_KEY = "sonar.python.pylint.reportPath";
    private static final String DEFAULT_REPORT_PATH = "pylint-reports/pylint-result-*.txt";
    private static final Logger LOG = LoggerFactory.getLogger(PylintImportSensor.class);
    private ActiveRules activeRules;
    private ResourcePerspectives resourcePerspectives;

    public PylintImportSensor(Settings conf, ActiveRules activeRules, FileSystem fileSystem, ResourcePerspectives resourcePerspectives) {
        super(conf, fileSystem);
        this.activeRules = activeRules;
        this.resourcePerspectives = resourcePerspectives;
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        FilePredicates p = this.fileSystem.predicates();
        boolean hasFiles = this.fileSystem.hasFiles(p.and(p.hasType(InputFile.Type.MAIN), p.hasLanguage("py")));
        boolean hasRules = !this.activeRules.findByRepository("Pylint").isEmpty();
        return hasFiles && hasRules && this.conf.getString(REPORT_PATH_KEY) != null;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected String defaultReportPath() {
        return DEFAULT_REPORT_PATH;
    }

    @Override
    protected void processReports(SensorContext context, List<File> reports) throws XMLStreamException {
        LinkedList<Issue> issues = new LinkedList<Issue>();
        for (File report : reports) {
            try {
                issues.addAll(this.parse(report));
            }
            catch (FileNotFoundException e) {
                LOG.error("Report '{}' cannot be found, details: '{}'", (Object)report, (Object)e);
            }
            catch (IOException e) {
                LOG.error("Report '{}' cannot be read, details: '{}'", (Object)report, (Object)e);
            }
        }
        this.saveIssues(issues);
    }

    private List<Issue> parse(File report) throws IOException {
        LinkedList<Issue> issues = new LinkedList<Issue>();
        PylintReportParser parser = new PylintReportParser();
        Scanner sc = new Scanner(report.toPath(), this.fileSystem.encoding().name());
        while (sc.hasNext()) {
            String line = sc.nextLine();
            Issue issue = parser.parseLine(line);
            if (issue == null) continue;
            issues.add(issue);
        }
        return issues;
    }

    private void saveIssues(List<Issue> issues) {
        for (Issue pylintIssue : issues) {
            String filepath = pylintIssue.getFilename();
            InputFile pyfile = this.fileSystem.inputFile(this.fileSystem.predicates().hasPath(filepath));
            if (pyfile != null) {
                ActiveRule rule = this.activeRules.find(RuleKey.of((String)"Pylint", (String)pylintIssue.getRuleId()));
                this.processRule(pylintIssue, pyfile, rule);
                continue;
            }
            LOG.warn("Cannot find the file '{}' in SonarQube, ignoring violation", (Object)filepath);
        }
    }

    private void processRule(Issue pylintIssue, InputFile pyfile, @Nullable ActiveRule rule) {
        if (rule != null) {
            Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (InputPath)pyfile);
            this.addIssue(pylintIssue, rule, issuable);
        } else {
            LOG.warn("Pylint rule '{}' is unknown in Sonar", (Object)pylintIssue.getRuleId());
        }
    }

    private void addIssue(Issue pylintIssue, ActiveRule rule, @Nullable Issuable issuable) {
        if (issuable != null) {
            org.sonar.api.issue.Issue issue = issuable.newIssueBuilder().ruleKey(rule.ruleKey()).line(Integer.valueOf(pylintIssue.getLine())).message(pylintIssue.getDescription()).build();
            issuable.addIssue(issue);
        }
    }
}

