/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.DefaultProjectFileSystem;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.plugins.python.Python;
import org.sonar.plugins.python.PythonPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonFile
extends org.sonar.api.resources.File {
    private static final String INITFILE = "__init__.py";
    private String parentPath = null;
    private PythonPackage parent = null;

    public PythonFile(String relPath, File absPath) {
        super(relPath);
        String parentPathCandidate;
        if (this.isInPythonPackage(absPath) && !"".equals(parentPathCandidate = this.parentPathOf(relPath))) {
            this.parentPath = this.parentPathOf(relPath);
        }
    }

    public static PythonFile fromIOFile(File file, Project project) {
        return PythonFile.fromIOFile(file, project.getFileSystem().getSourceDirs());
    }

    public static PythonFile fromIOFile(File file, List<File> sourceDirs) {
        String relPath = DefaultProjectFileSystem.getRelativePath((File)file, sourceDirs);
        if (relPath != null) {
            return new PythonFile(relPath, file);
        }
        return null;
    }

    public Directory getParent() {
        if (this.parentPath != null) {
            if (this.parent == null) {
                this.parent = PythonPackage.create(this.parentPath);
            }
            return this.parent;
        }
        return null;
    }

    public Language getLanguage() {
        return Python.INSTANCE;
    }

    private String parentPathOf(String relPath) {
        String parPath = "";
        if (relPath.indexOf(47) != -1) {
            parPath = StringUtils.substringBeforeLast((String)relPath, (String)"/");
        }
        return parPath;
    }

    private boolean isInPythonPackage(File absPath) {
        return new File(absPath.getParentFile(), INITFILE).isFile();
    }

    public boolean matchFilePattern(String antPattern) {
        String patternWithoutFileSuffix = StringUtils.substringBeforeLast((String)antPattern, (String)".");
        WildcardPattern matcher = WildcardPattern.create((String)patternWithoutFileSuffix, (String)".");
        return matcher.match(this.getKey());
    }
}

