/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.python.Issue;
import org.sonar.plugins.python.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonViolationsAnalyzer {
    private static final String FALLBACK_PYLINT = "pylint";
    private static final String ARGS = "-i y -f parseable -r n";
    private static final Pattern PATTERN = Pattern.compile("([^:]+):([0-9]+): \\[(.*)\\] (.*)");
    private String commandTemplate;

    PythonViolationsAnalyzer(String pylintPath, String pylintConfigPath) {
        String pylint = FALLBACK_PYLINT;
        if (pylintPath != null) {
            if (!new File(pylintPath).exists()) {
                throw new SonarException("Cannot find the pylint executable: " + pylintPath);
            }
            pylint = pylintPath;
        }
        this.commandTemplate = pylint + " " + ARGS;
        if (pylintConfigPath != null) {
            if (!new File(pylintConfigPath).exists()) {
                throw new SonarException("Cannot find the pylint configuration file: " + pylintConfigPath);
            }
            this.commandTemplate = this.commandTemplate + " --rcfile=" + pylintConfigPath;
        }
    }

    public List<Issue> analyze(String path, String[] environ) {
        String command = this.commandTemplate + " " + path;
        LinkedList<String> output = new LinkedList<String>();
        Utils.callCommand(command, environ, output);
        return this.parseOutput(output);
    }

    protected List<Issue> parseOutput(List<String> lines) {
        LinkedList<Issue> issues = new LinkedList<Issue>();
        String filename = null;
        String ruleid = null;
        String objname = null;
        String descr = null;
        if (!lines.isEmpty()) {
            for (String line : lines) {
                Matcher m = PATTERN.matcher(line);
                if (!m.matches() || m.groupCount() != 4) continue;
                filename = m.group(1);
                int linenr = Integer.valueOf(m.group(2));
                String[] parts = m.group(3).split(",");
                ruleid = parts[0].trim();
                if (parts.length == 2) {
                    objname = parts[1].trim();
                }
                descr = m.group(4);
                issues.add(new Issue(filename, linenr, ruleid, objname, descr));
            }
        }
        return issues;
    }
}

