/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.evomaster.clientJava.controller.db.VariableDescriptor;

public class DataRow {
    private final List<VariableDescriptor> variableDescriptors;
    private final List<Object> values;

    public DataRow(String name, Object value) {
        this(Arrays.asList(new VariableDescriptor(name)), Arrays.asList(value));
    }

    public DataRow(List<VariableDescriptor> descriptors, List<Object> values) {
        Objects.requireNonNull(descriptors);
        Objects.requireNonNull(values);
        if (descriptors.size() != values.size()) {
            throw new IllegalArgumentException("Size mismatch");
        }
        ArrayList<VariableDescriptor> list = new ArrayList<VariableDescriptor>();
        list.addAll(descriptors);
        this.variableDescriptors = Collections.unmodifiableList(list);
        ArrayList<Object> valList = new ArrayList<Object>();
        valList.addAll(values);
        this.values = Collections.unmodifiableList(valList);
    }

    public List<VariableDescriptor> getVariableDescriptors() {
        return this.variableDescriptors;
    }

    public Object getValue(int index) {
        return this.values.get(index);
    }

    public Object getValueByName(String name) {
        return this.getValueByName(name, null);
    }

    public Object getValueByName(String name, String table) {
        VariableDescriptor desc;
        int i;
        String t;
        Objects.requireNonNull(name);
        String n = name.trim();
        String string = t = table == null ? null : table.trim();
        if (n.equalsIgnoreCase("true")) {
            return true;
        }
        if (n.equalsIgnoreCase("false")) {
            return false;
        }
        if (t == null || t.isEmpty()) {
            for (i = 0; i < this.variableDescriptors.size(); ++i) {
                desc = this.variableDescriptors.get(i);
                if (!n.equalsIgnoreCase(desc.getAlias())) continue;
                return this.values.get(i);
            }
        }
        for (i = 0; i < this.variableDescriptors.size(); ++i) {
            desc = this.variableDescriptors.get(i);
            if (!n.equalsIgnoreCase(desc.getColumnName()) || t != null && !t.isEmpty() && !t.equalsIgnoreCase(desc.getTableName()) && !t.equalsIgnoreCase("___unnamed_table___")) continue;
            return this.values.get(i);
        }
        throw new IllegalArgumentException("No variable called '" + name + "' for table '" + table + "'");
    }

    public String getAsLine() {
        return this.values.stream().map(obj -> obj.toString()).collect(Collectors.joining(","));
    }
}

