/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.evomaster.clientJava.controller.db.QueryResult;
import org.evomaster.clientJava.controllerApi.dto.database.operations.InsertionDto;
import org.evomaster.clientJava.controllerApi.dto.database.operations.InsertionEntryDto;

public class SqlScriptRunner {
    private static final String DEFAULT_DELIMITER = ";";
    public static final Pattern delimP = Pattern.compile("^\\s*(--)?\\s*delimiter\\s*=?\\s*([^\\s]+)+\\s*.*$", 2);
    private static final String SINGLE_APOSTROPHE = "'";
    private static final String DOUBLE_APOSTROPHE = "''";
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public static void runScript(Connection connection, Reader reader) {
        Objects.requireNonNull(reader);
        SqlScriptRunner.runCommands(connection, new SqlScriptRunner().readCommands(reader));
    }

    public static void runScriptFromResourceFile(Connection connection, String resourcePath) {
        try {
            InputStream in = SqlScriptRunner.class.getResourceAsStream(resourcePath);
            SqlScriptRunner.runScript(connection, new InputStreamReader(in));
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCommands(Connection connection, List<String> commands) {
        try {
            boolean originalAutoCommit = connection.getAutoCommit();
            try {
                if (!originalAutoCommit) {
                    connection.setAutoCommit(true);
                }
                for (String command : commands) {
                    SqlScriptRunner.execCommand(connection, command);
                }
            }
            finally {
                connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    public List<String> readCommands(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer command = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                if (command == null) {
                    command = new StringBuffer();
                }
                String trimmedLine = line.trim();
                Matcher delimMatch = delimP.matcher(trimmedLine);
                if (trimmedLine.isEmpty() || trimmedLine.startsWith("//") || trimmedLine.startsWith("--")) continue;
                if (delimMatch.matches()) {
                    this.setDelimiter(delimMatch.group(2), false);
                    continue;
                }
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.delimiter) || this.fullLineDelimiter && trimmedLine.equals(this.delimiter)) {
                    command.append(line.substring(0, line.lastIndexOf(this.delimiter)));
                    command.append(" ");
                    list.add(command.toString());
                    command = null;
                    continue;
                }
                command.append(line);
                command.append("\n");
            }
            if (command != null) {
                list.add(command.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static void execInsert(Connection conn, List<InsertionDto> insertions) throws SQLException {
        if (insertions == null || insertions.isEmpty()) {
            throw new IllegalArgumentException("No data to insert");
        }
        String insertSql = "INSERT INTO ";
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (int i = 0; i < insertions.size(); ++i) {
            InsertionEntryDto entry;
            InsertionDto insDto = insertions.get(i);
            StringBuilder sql = new StringBuilder(insertSql);
            sql.append(insDto.targetTable).append(" (");
            sql.append(insDto.data.stream().map(e -> e.variableName).collect(Collectors.joining(",")));
            sql.append(" )  VALUES (");
            for (InsertionEntryDto e2 : insDto.data) {
                if (e2.printableValue != null || e2.foreignKeyToPreviouslyGeneratedRow == null || map.containsKey(e2.foreignKeyToPreviouslyGeneratedRow)) continue;
                throw new IllegalArgumentException("Insertion operation at position " + i + " has a foreign key reference to key " + e2.foreignKeyToPreviouslyGeneratedRow + " but that was not processed." + " Processed primary keys: " + map.keySet().stream().map(v -> v.toString()).collect(Collectors.joining(", ")));
            }
            sql.append(insDto.data.stream().map(e -> e.printableValue != null ? SqlScriptRunner.replaceQuotes(e.printableValue) : ((Long)map.get(e.foreignKeyToPreviouslyGeneratedRow)).toString()).collect(Collectors.joining(",")));
            sql.append(");");
            Long id = SqlScriptRunner.execInsert(conn, sql.toString());
            if (id == null && (entry = (InsertionEntryDto)insDto.data.stream().filter(e -> e.keepAutoGeneratedValue != null && e.keepAutoGeneratedValue == true).findFirst().orElse(null)) != null) {
                String columnName = entry.variableName;
                long previouslyGeneratedValue = (Long)map.get(entry.foreignKeyToPreviouslyGeneratedRow);
                map.put(insDto.id, previouslyGeneratedValue);
            }
            if (id == null) continue;
            map.put(insDto.id, id);
        }
    }

    private static String replaceQuotes(String value) {
        if (value.contains(SINGLE_APOSTROPHE)) {
            String oldValue = value;
            value = value.replaceAll(SINGLE_APOSTROPHE, DOUBLE_APOSTROPHE);
            assert (!oldValue.equals(value));
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return SINGLE_APOSTROPHE + value.substring(1, value.length() - 1) + SINGLE_APOSTROPHE;
        }
        return value;
    }

    public static Long execInsert(Connection conn, String command) throws SQLException {
        String insert = "INSERT ";
        if (!(command = command.trim()).toUpperCase().startsWith(insert)) {
            throw new IllegalArgumentException("SQL command is not an INSERT\n" + command);
        }
        Statement statement = conn.createStatement();
        try {
            statement.executeUpdate(command, 1);
        }
        catch (SQLException e) {
            statement.close();
            String errText = String.format("Error executing '%s': %s", command, e.getMessage());
            throw new SQLException(errText, e);
        }
        ResultSet generatedKeys = statement.getGeneratedKeys();
        Long id = null;
        if (generatedKeys.next()) {
            id = generatedKeys.getLong(1);
        }
        statement.close();
        return id;
    }

    public static QueryResult execCommand(Connection conn, String command) throws SQLException {
        Statement statement = conn.createStatement();
        try {
            statement.execute(command);
        }
        catch (SQLException e) {
            statement.close();
            String errText = String.format("Error executing '%s': %s", command, e.getMessage());
            throw new SQLException(errText, e);
        }
        ResultSet result = statement.getResultSet();
        QueryResult queryResult = new QueryResult(result);
        statement.close();
        return queryResult;
    }
}

