/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.controller.internal;

import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.controller.SutHandler;
import org.evomaster.clientJava.controller.db.SqlScriptRunner;
import org.evomaster.clientJava.controller.internal.EMController;
import org.evomaster.clientJava.controller.internal.db.SchemaExtractor;
import org.evomaster.clientJava.controller.internal.db.SqlHandler;
import org.evomaster.clientJava.controllerApi.dto.AuthenticationDto;
import org.evomaster.clientJava.controllerApi.dto.ExtraHeuristicDto;
import org.evomaster.clientJava.controllerApi.dto.database.execution.ReadDbDataDto;
import org.evomaster.clientJava.controllerApi.dto.database.operations.InsertionDto;
import org.evomaster.clientJava.controllerApi.dto.database.schema.DbSchemaDto;
import org.evomaster.clientJava.instrumentation.TargetInfo;
import shaded.org.eclipse.jetty.server.AbstractNetworkConnector;
import shaded.org.eclipse.jetty.server.Server;
import shaded.org.eclipse.jetty.server.handler.ErrorHandler;
import shaded.org.eclipse.jetty.servlet.ServletContextHandler;
import shaded.org.eclipse.jetty.servlet.ServletHolder;
import shaded.org.glassfish.jersey.jackson.JacksonFeature;
import shaded.org.glassfish.jersey.logging.LoggingFeature;
import shaded.org.glassfish.jersey.server.ResourceConfig;
import shaded.org.glassfish.jersey.servlet.ServletContainer;

public abstract class SutController
implements SutHandler {
    private int controllerPort = 40100;
    private String controllerHost = "localhost";
    private final SqlHandler sqlHandler = new SqlHandler();
    private Server controllerServer;
    private DbSchemaDto schemaDto;

    public final boolean startTheControllerServer() {
        ResourceConfig config = new ResourceConfig();
        config.register((Class)JacksonFeature.class);
        config.register(new EMController(this));
        config.register((Class)LoggingFeature.class);
        this.controllerServer = new Server(InetSocketAddress.createUnresolved(this.getControllerHost(), this.getControllerPort()));
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        this.controllerServer.setErrorHandler(errorHandler);
        ServletHolder servlet = new ServletHolder(new ServletContainer(config));
        ServletContextHandler context = new ServletContextHandler(this.controllerServer, "/controller/api/*");
        context.addServlet(servlet, "/*");
        try {
            this.controllerServer.start();
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to start Jetty: " + e.getMessage());
            this.controllerServer.destroy();
        }
        this.newSearch();
        SimpleLogger.info("Started controller server on: " + this.controllerServer.getURI());
        return true;
    }

    public final boolean stopTheControllerServer() {
        try {
            this.controllerServer.stop();
            return true;
        }
        catch (Exception e) {
            SimpleLogger.error(e.toString());
            return false;
        }
    }

    public final int getControllerServerPort() {
        return ((AbstractNetworkConnector)this.controllerServer.getConnectors()[0]).getLocalPort();
    }

    public final int getControllerPort() {
        return this.controllerPort;
    }

    public final void setControllerPort(int controllerPort) {
        this.controllerPort = controllerPort;
    }

    public final String getControllerHost() {
        return this.controllerHost;
    }

    public final void setControllerHost(String controllerHost) {
        this.controllerHost = controllerHost;
    }

    @Override
    public void execInsertionsIntoDatabase(List<InsertionDto> insertions) {
        Connection connection = this.getConnection();
        if (connection == null) {
            throw new IllegalStateException("No connection to database");
        }
        try {
            SqlScriptRunner.execInsert(connection, insertions);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public final void handleSql(String sql) {
        Objects.requireNonNull(sql);
        this.sqlHandler.handle(sql);
    }

    public final void initSqlHandler() {
        this.sqlHandler.setConnection(this.getConnection());
    }

    public final void resetExtraHeuristics() {
        this.sqlHandler.reset();
    }

    public final ExtraHeuristicDto getExtraHeuristics() {
        ExtraHeuristicDto dto = new ExtraHeuristicDto();
        dto.toMinimize.addAll(this.sqlHandler.getDistances());
        ReadDbDataDto readDbDataDto = new ReadDbDataDto();
        readDbDataDto.queriedData = this.sqlHandler.getReadData();
        readDbDataDto.emptySqlSelects = this.sqlHandler.getEmptySqlSelects();
        if (!readDbDataDto.queriedData.isEmpty() || !readDbDataDto.emptySqlSelects.isEmpty()) {
            dto.readDbData = readDbDataDto;
        }
        return dto;
    }

    public final DbSchemaDto getSqlDatabaseSchema() {
        if (this.schemaDto != null) {
            return this.schemaDto;
        }
        if (this.getConnection() == null) {
            return null;
        }
        try {
            this.schemaDto = SchemaExtractor.extract(this.getConnection());
        }
        catch (Exception e) {
            SimpleLogger.error("Failed to extract the SQL Database Schema: " + e.getMessage());
            return null;
        }
        return this.schemaDto;
    }

    public abstract void newSearch();

    public abstract void newTest();

    public abstract void newAction(int var1);

    public abstract boolean isInstrumentationActivated();

    public abstract boolean isSutRunning();

    public abstract String getPackagePrefixesToCover();

    public abstract String getUrlOfSwaggerJSON();

    public abstract List<AuthenticationDto> getInfoForAuthentication();

    public abstract Connection getConnection();

    public abstract String getDatabaseDriverName();

    public abstract List<TargetInfo> getTargetInfos(Collection<Integer> var1);

    public abstract List<String> getEndpointsToSkip();
}

