/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.clientJava.instrumentation.external;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.List;
import org.evomaster.clientJava.clientUtil.SimpleLogger;
import org.evomaster.clientJava.instrumentation.TargetInfo;
import org.evomaster.clientJava.instrumentation.external.Command;

public class ServerController {
    private ServerSocket server;
    private Socket socket;
    protected ObjectOutputStream out;
    protected ObjectInputStream in;

    public int startServer() {
        this.closeServer();
        try {
            this.server = new ServerSocket(0);
            this.server.setSoTimeout(10000);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return this.server.getLocalPort();
    }

    public void closeServer() {
        if (this.server != null) {
            try {
                this.server.close();
                this.server = null;
                this.socket = null;
                this.in = null;
                this.out = null;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public boolean waitForIncomingConnection() {
        try {
            this.socket = this.server.accept();
            this.socket.setSoTimeout(20000);
            this.out = new ObjectOutputStream(this.socket.getOutputStream());
            this.in = new ObjectInputStream(this.socket.getInputStream());
        }
        catch (InterruptedIOException e) {
            return false;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this.isConnectionOn();
    }

    public boolean isConnectionOn() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public boolean sendCommand(Command command) {
        return this.sendObject(command);
    }

    public boolean sendObject(Object obj) {
        if (!this.isConnectionOn()) {
            return false;
        }
        try {
            this.out.writeObject(obj);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public Object waitAndGetResponse() {
        if (!this.isConnectionOn()) {
            return null;
        }
        try {
            Object obj = this.in.readObject();
            return obj;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean sendAndExpectACK(Command command) {
        boolean sent = this.sendCommand(command);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return false;
        }
        return this.waitForAck();
    }

    public boolean sendWithDataAndExpectACK(Command command, Object data) {
        boolean sent = this.sendCommand(command);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return false;
        }
        sent = this.sendObject(data);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return false;
        }
        return this.waitForAck();
    }

    private boolean waitForAck() {
        Object response = this.waitAndGetResponse();
        if (response == null) {
            SimpleLogger.error("Failed to read ACK response");
            return false;
        }
        if (!Command.ACK.equals(response)) {
            throw new IllegalStateException("Invalid response: " + response);
        }
        return true;
    }

    public boolean resetForNewSearch() {
        return this.sendAndExpectACK(Command.NEW_SEARCH);
    }

    public boolean resetForNewTest() {
        return this.sendAndExpectACK(Command.NEW_TEST);
    }

    public boolean setActionIndex(int actionIndex) {
        return this.sendWithDataAndExpectACK(Command.ACTION_INDEX, actionIndex);
    }

    public List<TargetInfo> getTargetInfos(Collection<Integer> ids) {
        boolean sent = this.sendCommand(Command.TARGET_INFOS);
        if (!sent) {
            SimpleLogger.error("Failed to send message");
            return null;
        }
        try {
            this.out.writeObject(ids);
        }
        catch (IOException e) {
            SimpleLogger.error("Failed to send ids");
            return null;
        }
        Object response = this.waitAndGetResponse();
        if (response == null) {
            SimpleLogger.error("Failed to read response about covered targets");
            return null;
        }
        if (!(response instanceof List)) {
            throw new IllegalStateException("Invalid response: " + response);
        }
        return (List)response;
    }
}

