/*
 * Decompiled with CFR 0.152.
 */
package org.evomaster.client.java.sql.internal;

import shaded.net.sf.jsqlparser.expression.Expression;
import shaded.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import shaded.net.sf.jsqlparser.statement.Statement;
import shaded.net.sf.jsqlparser.statement.delete.Delete;
import shaded.net.sf.jsqlparser.statement.select.PlainSelect;
import shaded.net.sf.jsqlparser.statement.select.Select;
import shaded.net.sf.jsqlparser.statement.update.Update;

public class ParserUtils {
    public static boolean isSelect(String sql) {
        return ParserUtils.startsWithIgnoreCase(sql, "select") && !ParserUtils.isASequence(sql);
    }

    public static boolean isDelete(String sql) {
        return ParserUtils.startsWithIgnoreCase(sql, "delete");
    }

    public static boolean isUpdate(String sql) {
        return ParserUtils.startsWithIgnoreCase(sql, "update");
    }

    public static boolean isInsert(String sql) {
        return ParserUtils.startsWithIgnoreCase(sql, "insert");
    }

    private static boolean startsWithIgnoreCase(String input, String prefix) {
        return input != null && input.trim().toLowerCase().startsWith(prefix);
    }

    private static boolean isASequence(String input) {
        return input != null && input.trim().toLowerCase().matches(".*(currval|nextval).*");
    }

    public static boolean isSelectOne(String sql) {
        return sql != null && sql.trim().toLowerCase().matches("select\\s+1\\s*;?");
    }

    public static Expression getWhere(Statement statement) {
        if (statement instanceof Select) {
            Select select = (Select)statement;
            PlainSelect plainSelect = select.getPlainSelect();
            return plainSelect.getWhere();
        }
        if (statement instanceof Delete) {
            return ((Delete)statement).getWhere();
        }
        if (statement instanceof Update) {
            return ((Update)statement).getWhere();
        }
        throw new IllegalArgumentException("Cannot handle statement: " + statement.toString());
    }

    public static Statement asStatement(String statement) {
        Statement stmt;
        try {
            stmt = CCJSqlParserUtil.parse(statement);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid SQL statement: " + statement + "\n" + e.getMessage(), e);
        }
        return stmt;
    }

    public static boolean canParseSqlStatement(String statement) {
        try {
            CCJSqlParserUtil.parse(statement);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

