/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api.http;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.gitlab.api.AuthMethod;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.GitlabAPIException;
import org.gitlab.api.TokenType;
import org.gitlab.api.http.Method;

public class GitlabHTTPRequestor {
    private static final Pattern PAGE_PATTERN = Pattern.compile("([&|?])page=(\\d+)");
    private final GitlabAPI root;
    private Method method = Method.GET;
    private Map<String, Object> data = new HashMap<String, Object>();
    private Map<String, File> attachments = new HashMap<String, File>();
    private String apiToken;
    private TokenType tokenType;
    private AuthMethod authMethod;

    public GitlabHTTPRequestor(GitlabAPI root) {
        this.root = root;
    }

    public GitlabHTTPRequestor authenticate(String token, TokenType type, AuthMethod method) {
        this.apiToken = token;
        this.tokenType = type;
        this.authMethod = method;
        return this;
    }

    public GitlabHTTPRequestor method(Method method) {
        this.method = method;
        return this;
    }

    public GitlabHTTPRequestor with(String key, Object value) {
        if (value != null && key != null) {
            this.data.put(key, value);
        }
        return this;
    }

    public GitlabHTTPRequestor withAttachment(String key, File file) {
        if (file != null && key != null) {
            this.attachments.put(key, file);
        }
        return this;
    }

    public <T> T to(String tailAPIUrl, T instance) throws IOException {
        return this.to(tailAPIUrl, null, instance);
    }

    public <T> T to(String tailAPIUrl, Class<T> type) throws IOException {
        return this.to(tailAPIUrl, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T to(String tailAPIUrl, Class<T> type, T instance) throws IOException {
        HttpURLConnection connection = null;
        try {
            T t;
            connection = this.setupConnection(this.root.getAPIUrl(tailAPIUrl));
            if (this.hasAttachments()) {
                this.submitAttachments(connection);
            } else if (this.hasOutput()) {
                this.submitData(connection);
            } else if (Method.PUT.equals((Object)this.method)) {
                connection.setDoOutput(true);
                connection.setFixedLengthStreamingMode(0);
            }
            try {
                t = this.parse(connection, type, instance);
            }
            catch (IOException e) {
                T t2;
                block12: {
                    this.handleAPIError(e, connection);
                    t2 = null;
                    if (connection == null) break block12;
                    connection.disconnect();
                }
                return t2;
            }
            return t;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public <T> List<T> getAll(String tailUrl, Class<T[]> type) {
        ArrayList<T> results = new ArrayList<T>();
        Iterator<T[]> iterator = this.asIterator(tailUrl, type);
        while (iterator.hasNext()) {
            T[] requests = iterator.next();
            if (requests.length <= 0) continue;
            results.addAll(Arrays.asList(requests));
        }
        return results;
    }

    public <T> Iterator<T> asIterator(final String tailApiUrl, final Class<T> type) {
        this.method(Method.GET);
        if (!this.data.isEmpty()) {
            throw new IllegalStateException();
        }
        return new Iterator<T>(){
            T next;
            URL url;
            {
                try {
                    this.url = GitlabHTTPRequestor.this.root.getAPIUrl(tailApiUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                this.fetch();
                if (this.next != null && this.next.getClass().isArray()) {
                    Object[] arr = (Object[])this.next;
                    return arr.length != 0;
                }
                return this.next != null;
            }

            @Override
            public T next() {
                this.fetch();
                Object record = this.next;
                if (record == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return record;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void fetch() {
                if (this.next != null) {
                    return;
                }
                if (this.url == null) {
                    return;
                }
                try {
                    HttpURLConnection connection = GitlabHTTPRequestor.this.setupConnection(this.url);
                    try {
                        this.next = GitlabHTTPRequestor.this.parse(connection, type, null);
                        assert (this.next != null);
                        this.findNextUrl();
                    }
                    catch (IOException e) {
                        GitlabHTTPRequestor.this.handleAPIError(e, connection);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private void findNextUrl() throws MalformedURLException {
                String url = this.url.toString();
                this.url = null;
                Matcher matcher = PAGE_PATTERN.matcher(url);
                if (matcher.find()) {
                    Integer page = Integer.parseInt(matcher.group(2)) + 1;
                    this.url = new URL(matcher.replaceAll(matcher.group(1) + "page=" + page));
                } else {
                    this.url = new URL(url + (url.indexOf(63) > 0 ? (char)'&' : '?') + "page=2");
                }
            }
        };
    }

    private void submitAttachments(HttpURLConnection connection) throws IOException {
        String boundary = Long.toHexString(System.currentTimeMillis());
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        String charset = "UTF-8";
        String CRLF = "\r\n";
        OutputStream output = connection.getOutputStream();
        try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);){
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                String paramName = entry.getKey();
                String param = GitlabAPI.MAPPER.writeValueAsString(entry.getValue());
                writer.append("--").append(boundary).append(CRLF);
                writer.append("Content-Disposition: form-data; name=\"").append(paramName).append("\"").append(CRLF);
                writer.append("Content-Type: text/plain; charset=").append(charset).append(CRLF);
                writer.append(CRLF).append(param).append(CRLF).flush();
            }
            for (Map.Entry<String, Object> entry : this.attachments.entrySet()) {
                File binaryFile = (File)entry.getValue();
                writer.append("--").append(boundary).append(CRLF);
                writer.append("Content-Disposition: form-data; name=\"").append(entry.getKey()).append("\"; filename=\"").append(binaryFile.getName()).append("\"").append(CRLF);
                writer.append("Content-Type: ").append(URLConnection.guessContentTypeFromName(binaryFile.getName())).append(CRLF);
                writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                writer.append(CRLF).flush();
                try (FileReader fileReader = new FileReader(binaryFile);){
                    IOUtils.copy((Reader)fileReader, (OutputStream)output);
                }
                output.flush();
                writer.append(CRLF).flush();
            }
            writer.append("--").append(boundary).append("--").append(CRLF).flush();
        }
    }

    private void submitData(HttpURLConnection connection) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        GitlabAPI.MAPPER.writeValue(connection.getOutputStream(), this.data);
    }

    private boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    private boolean hasOutput() {
        return this.method.equals((Object)Method.POST) || this.method.equals((Object)Method.PUT) && !this.data.isEmpty();
    }

    private HttpURLConnection setupConnection(URL url) throws IOException {
        HttpURLConnection connection;
        if (this.root.isIgnoreCertificateErrors()) {
            this.ignoreCertificateErrors();
        }
        if (this.apiToken != null && this.authMethod == AuthMethod.URL_PARAMETER) {
            String urlWithAuth = url.toString();
            urlWithAuth = urlWithAuth + (urlWithAuth.indexOf(63) > 0 ? (char)'&' : '?') + this.tokenType.getTokenParamName() + "=" + this.apiToken;
            url = new URL(urlWithAuth);
        }
        HttpURLConnection httpURLConnection = connection = this.root.getProxy() != null ? (HttpURLConnection)url.openConnection(this.root.getProxy()) : (HttpURLConnection)url.openConnection();
        if (this.apiToken != null && this.authMethod == AuthMethod.HEADER) {
            connection.setRequestProperty(this.tokenType.getTokenHeaderName(), String.format(this.tokenType.getTokenHeaderFormat(), this.apiToken));
        }
        connection.setReadTimeout(this.root.getResponseReadTimeout());
        connection.setConnectTimeout(this.root.getConnectionTimeout());
        try {
            connection.setRequestMethod(this.method.name());
        }
        catch (ProtocolException e) {
            try {
                Field methodField = connection.getClass().getDeclaredField("method");
                methodField.setAccessible(true);
                methodField.set(connection, this.method.name());
            }
            catch (Exception x) {
                throw new IOException("Failed to set the custom verb", x);
            }
        }
        connection.setRequestProperty("User-Agent", this.root.getUserAgent());
        connection.setRequestProperty("Accept-Encoding", "gzip");
        return connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T parse(HttpURLConnection connection, Class<T> type, T instance) throws IOException {
        InputStreamReader reader = null;
        try {
            if (byte[].class == type) {
                T t = type.cast(IOUtils.toByteArray((InputStream)this.wrapStream(connection, connection.getInputStream())));
                return t;
            }
            reader = new InputStreamReader(this.wrapStream(connection, connection.getInputStream()), "UTF-8");
            String json = IOUtils.toString((Reader)reader);
            if (type != null && type == String.class) {
                T t = type.cast(json);
                IOUtils.closeQuietly((Reader)reader);
                return t;
            }
            if (type != null && type != Void.class) {
                Object object = GitlabAPI.MAPPER.readValue(json, type);
                IOUtils.closeQuietly((Reader)reader);
                return (T)object;
            }
            if (instance != null) {
                Object object = GitlabAPI.MAPPER.readerForUpdating(instance).readValue(json);
                IOUtils.closeQuietly((Reader)reader);
                return (T)object;
            }
            T t = null;
            IOUtils.closeQuietly((Reader)reader);
            return t;
        }
        catch (SSLHandshakeException e) {
            throw new SSLException("You can disable certificate checking by setting ignoreCertificateErrors on GitlabHTTPRequestor.", e);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private InputStream wrapStream(HttpURLConnection connection, InputStream inputStream) throws IOException {
        String encoding = connection.getContentEncoding();
        if (encoding == null || inputStream == null) {
            return inputStream;
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(inputStream);
        }
        throw new UnsupportedOperationException("Unexpected Content-Encoding: " + encoding);
    }

    private void handleAPIError(IOException e, HttpURLConnection connection) throws IOException {
        if (e instanceof FileNotFoundException || e instanceof SocketTimeoutException || e instanceof ConnectException) {
            throw e;
        }
        InputStream es = this.wrapStream(connection, connection.getErrorStream());
        try {
            String error = null;
            if (es != null) {
                error = IOUtils.toString((InputStream)es, (String)"UTF-8");
            }
            throw new GitlabAPIException(error, connection.getResponseCode(), e);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)es);
            throw throwable;
        }
    }

    private void ignoreCertificateErrors() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier nullVerifier = (hostname, session) -> true;
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(nullVerifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

