/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.codecs;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.codecs.ErrorHandlers;
import com.oracle.graal.python.builtins.modules.codecs.PEncodingMap;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyBytesCheckNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.graal.python.nodes.PNodeWithRaiseAndIndirectCall;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.ByteArrayBuilder;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.Arrays;

public final class CharmapNodes {
    private static final TruffleString T_CHARMAP = PythonUtils.tsLiteral("charmap");

    private CharmapNodes() {
    }

    static int encodingMapLookup(int cp, PEncodingMap map) {
        if (cp > 65535) {
            return -1;
        }
        if (cp == 0) {
            return 0;
        }
        int l1 = cp >> 11;
        int l2 = cp >> 7 & 0xF;
        int l3 = cp & 0x7F;
        int i = map.level1[l1] & 0xFF;
        if (i == 255) {
            return -1;
        }
        if ((i = map.level23[16 * i + l2] & 0xFF) == 255) {
            return -1;
        }
        if ((i = map.level23[16 * map.count2 + 128 * i + l3] & 0xFF) == 0) {
            return -1;
        }
        return i;
    }

    public static abstract class PyUnicodeDecodeCharmapNode
    extends PNodeWithRaiseAndIndirectCall {
        private static final int UNDEFINED_MAPPING = 65534;

        public abstract TruffleString execute(VirtualFrame var1, Object var2, TruffleString var3, Object var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        TruffleString decodeLatin1(VirtualFrame frame, Object data, TruffleString errors, PNone mapping, @CachedLibrary(value="data") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") @Cached.Shared PythonBufferAccessLibrary bufferLib, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            Object dataBuffer = bufferAcquireLib.acquireReadonly(data, frame, this.getContext(), this.getLanguage(), this);
            try {
                int len = bufferLib.getBufferLength(dataBuffer);
                byte[] src = bufferLib.getInternalOrCopiedByteArray(dataBuffer);
                TruffleString latin1 = fromByteArrayNode.execute(src, 0, len, TruffleString.Encoding.ISO_8859_1, true);
                TruffleString truffleString = switchEncodingNode.execute((AbstractTruffleString)latin1, PythonUtils.TS_ENCODING);
                return truffleString;
            }
            finally {
                bufferLib.release(dataBuffer, frame, this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3", guards={"isBuiltinString(inliningTarget, mappingObj, mappingClassProfile)"})
        static TruffleString decodeStringMapping(VirtualFrame frame, Object data, TruffleString errors, Object mappingObj, @Bind(value="this") Node inliningTarget, @Bind(value="getIndirectCallNode()") IndirectCallNode indirectCallNode, @CachedLibrary(value="data") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") @Cached.Shared PythonBufferAccessLibrary bufferLib, @Cached @Cached.Exclusive BuiltinClassProfiles.IsBuiltinObjectProfile mappingClassProfile, @Cached @Cached.Exclusive CastToTruffleStringNode castToTruffleStringNode, @Cached @Cached.Shared TruffleString.CodePointLengthNode codePointLengthNode, @Cached @Cached.Shared TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached @Cached.Shared TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached @Cached.Shared TruffleStringBuilder.AppendStringNode appendStringNode, @Cached @Cached.Shared TruffleStringBuilder.ToStringNode toStringNode, @Cached @Cached.Exclusive ErrorHandlers.CallDecodingErrorHandlerNode callErrorHandlerNode) {
            int srcLen;
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            ErrorHandlers.ErrorHandlerCache cache = new ErrorHandlers.ErrorHandlerCache();
            Object srcObj = data;
            int pos = 0;
            TruffleString mapping = castToTruffleStringNode.execute(inliningTarget, mappingObj);
            int mappingLen = codePointLengthNode.execute((AbstractTruffleString)mapping, PythonUtils.TS_ENCODING);
            TruffleStringBuilder tsb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            do {
                int errorStartPos;
                Object srcBuf = bufferAcquireLib.acquireReadonly(srcObj, frame, context, language, indirectCallNode);
                try {
                    srcLen = bufferLib.getBufferLength(srcBuf);
                    byte[] src = bufferLib.getInternalOrCopiedByteArray(srcBuf);
                    errorStartPos = -1;
                    while (pos < srcLen) {
                        int index = src[pos] & 0xFF;
                        if (index >= mappingLen) {
                            errorStartPos = pos;
                            break;
                        }
                        int cp = codePointAtIndexNode.execute((AbstractTruffleString)mapping, index, PythonUtils.TS_ENCODING);
                        if (cp == 65534) {
                            errorStartPos = pos;
                            break;
                        }
                        appendCodePointNode.execute(tsb, cp, 1, true);
                        ++pos;
                    }
                }
                finally {
                    bufferLib.release(srcBuf, frame, context, language, indirectCallNode);
                }
                if (errorStartPos == -1) continue;
                ErrorHandlers.DecodingErrorHandlerResult result = callErrorHandlerNode.execute(frame, inliningTarget, cache, errors, T_CHARMAP, srcObj, errorStartPos, errorStartPos + 1, ErrorMessages.CHARACTER_MAPS_TO_UNDEFINED);
                appendStringNode.execute(tsb, (AbstractTruffleString)result.str);
                pos = result.newPos;
                srcObj = result.newSrcObj;
            } while (pos < srcLen);
            return toStringNode.execute(tsb, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3", guards={"!isBuiltinString(inliningTarget, mappingObj, mappingClassProfile)", "!isPNone(mappingObj)"})
        static TruffleString decodeGenericMapping(VirtualFrame frame, Object data, TruffleString errors, Object mappingObj, @Bind(value="this") Node inliningTarget, @Bind(value="getIndirectCallNode()") IndirectCallNode indirectCallNode, @CachedLibrary(value="data") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") @Cached.Shared PythonBufferAccessLibrary bufferLib, @Cached @Cached.Exclusive BuiltinClassProfiles.IsBuiltinObjectProfile mappingClassProfile, @Cached PyObjectGetItem pyObjectGetItemNode, @Cached @Cached.Exclusive BuiltinClassProfiles.IsBuiltinSubtypeObjectProfile isLookupErrorProfile, @Cached PyLongCheckNode pyLongCheckNode, @Cached PyLongAsLongNode pyLongAsLongNode, @Cached PyUnicodeCheckNode pyUnicodeCheckNode, @Cached @Cached.Exclusive CastToTruffleStringNode castToTruffleStringNode, @Cached @Cached.Shared TruffleString.CodePointLengthNode codePointLengthNode, @Cached @Cached.Shared TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached @Cached.Shared TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached @Cached.Shared TruffleStringBuilder.AppendStringNode appendStringNode, @Cached @Cached.Shared TruffleStringBuilder.ToStringNode toStringNode, @Cached @Cached.Exclusive ErrorHandlers.CallDecodingErrorHandlerNode callErrorHandlerNode, @Cached InlinedConditionProfile longValuesProfile, @Cached InlinedConditionProfile strValuesProfile, @Cached InlinedConditionProfile errProfile, @Cached PRaiseNode.Lazy raiseNode) {
            int srcLen;
            PythonContext context = PythonContext.get(inliningTarget);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            ErrorHandlers.ErrorHandlerCache cache = new ErrorHandlers.ErrorHandlerCache();
            Object srcObj = data;
            int pos = 0;
            TruffleStringBuilder tsb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            do {
                int errorStartPos;
                Object srcBuf = bufferAcquireLib.acquireReadonly(srcObj, frame, context, language, indirectCallNode);
                try {
                    srcLen = bufferLib.getBufferLength(srcBuf);
                    byte[] src = bufferLib.getInternalOrCopiedByteArray(srcBuf);
                    errorStartPos = -1;
                    while (pos < srcLen) {
                        Object item;
                        int key = src[pos] & 0xFF;
                        try {
                            item = pyObjectGetItemNode.execute((Frame)frame, inliningTarget, mappingObj, key);
                        }
                        catch (PException e) {
                            e.expectSubclass(frame, inliningTarget, PythonBuiltinClassType.LookupError, isLookupErrorProfile);
                            errorStartPos = pos;
                            break;
                        }
                        if (item == PNone.NONE) {
                            errorStartPos = pos;
                            break;
                        }
                        if (longValuesProfile.profile(inliningTarget, pyLongCheckNode.execute(inliningTarget, item))) {
                            long value = pyLongAsLongNode.execute((Frame)frame, inliningTarget, item);
                            if (value == 65534L) {
                                errorStartPos = pos;
                                break;
                            }
                            if (value < 0L || value > 0x10FFFFL) {
                                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CHARACTER_MAPPING_MUST_BE_IN_RANGE, PInt.toHexString(0x110000L));
                            }
                            appendCodePointNode.execute(tsb, (int)value, 1, true);
                        } else if (strValuesProfile.profile(inliningTarget, pyUnicodeCheckNode.execute(inliningTarget, item))) {
                            TruffleString ts = castToTruffleStringNode.execute(inliningTarget, item);
                            if (codePointLengthNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING) == 1) {
                                int cp = codePointAtIndexNode.execute((AbstractTruffleString)ts, 0, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                                if (cp == 65534) {
                                    errorStartPos = pos;
                                    break;
                                }
                                appendCodePointNode.execute(tsb, cp, 1, true);
                            } else {
                                appendStringNode.execute(tsb, (AbstractTruffleString)castToTruffleStringNode.execute(inliningTarget, item));
                            }
                        } else {
                            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CHARACTER_MAPPING_MUST_RETURN_INT_NONE_OR_STR);
                        }
                        ++pos;
                    }
                }
                finally {
                    bufferLib.release(srcBuf, frame, context, language, indirectCallNode);
                }
                if (!errProfile.profile(inliningTarget, errorStartPos != -1)) continue;
                ErrorHandlers.DecodingErrorHandlerResult result = callErrorHandlerNode.execute(frame, inliningTarget, cache, errors, T_CHARMAP, srcObj, errorStartPos, errorStartPos + 1, ErrorMessages.CHARACTER_MAPS_TO_UNDEFINED);
                appendStringNode.execute(tsb, (AbstractTruffleString)result.str);
                pos = result.newPos;
                srcObj = result.newSrcObj;
            } while (pos < srcLen);
            return toStringNode.execute(tsb, false);
        }

        IndirectCallNode getIndirectCallNode() {
            return this;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CharmapEncodeLookupNode
    extends Node {
        CharmapEncodeLookupNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, int var3, Object var4);

        @Specialization
        static Object doIt(VirtualFrame frame, Node inliningTarget, int cp, Object mapping, @Cached PyObjectGetItem pyObjectGetItemNode, @Cached BuiltinClassProfiles.IsBuiltinSubtypeObjectProfile isLookupErrorProfile, @Cached PyLongCheckNode pyLongCheckNode, @Cached PyLongAsLongNode pyLongAsLongNode, @Cached PyBytesCheckNode pyBytesCheckNode, @Cached PRaiseNode.Lazy raiseNode) {
            Object item;
            try {
                item = pyObjectGetItemNode.execute((Frame)frame, inliningTarget, mapping, cp);
            }
            catch (PException e) {
                e.expectSubclass(frame, inliningTarget, PythonBuiltinClassType.LookupError, isLookupErrorProfile);
                return PNone.NONE;
            }
            if (item == PNone.NONE) {
                return item;
            }
            if (pyLongCheckNode.execute(inliningTarget, item)) {
                long value = pyLongAsLongNode.execute((Frame)frame, inliningTarget, item);
                if (value < 0L || value > 255L) {
                    raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CHARACTER_MAPPING_MUST_BE_IN_RANGE_256);
                }
                return value;
            }
            if (pyBytesCheckNode.execute(inliningTarget, item)) {
                return item;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CHARACTER_MAPPING_MUST_RETURN_INT_BYTES_OR_NONE_NOT_P, item);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CharmapEncodeOutputNode
    extends Node {
        CharmapEncodeOutputNode() {
        }

        abstract boolean execute(VirtualFrame var1, Node var2, int var3, Object var4, ByteArrayBuilder var5);

        @Specialization
        static boolean doEncodingMap(int cp, PEncodingMap mapping, ByteArrayBuilder builder) {
            int res = CharmapNodes.encodingMapLookup(cp, mapping);
            if (res == -1) {
                return false;
            }
            assert (res >= 0 && res <= 255);
            builder.add((byte)res);
            return true;
        }

        @Fallback
        static boolean doGenericMapping(VirtualFrame frame, Node inliningTarget, int cp, Object mapping, ByteArrayBuilder builder, @Cached CharmapEncodeLookupNode charmapEncodeLookupNode, @Cached(inline=false) ByteArrayBuilder.AppendBytesNode appendBytesNode) {
            Object rep = charmapEncodeLookupNode.execute(frame, inliningTarget, cp, mapping);
            if (rep == PNone.NONE) {
                return false;
            }
            if (rep instanceof Long) {
                Long value = (Long)rep;
                assert (value >= 0L && value <= 255L);
                builder.add(value.byteValue());
            } else {
                appendBytesNode.execute(frame, builder, rep);
            }
            return true;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CharmapEncodingErrorNode
    extends Node {
        CharmapEncodingErrorNode() {
        }

        abstract int execute(VirtualFrame var1, Node var2, ErrorHandlers.ErrorHandlerCache var3, TruffleString var4, int var5, int var6, TruffleString var7, Object var8, ByteArrayBuilder var9);

        @Specialization
        static int doIt(VirtualFrame frame, Node inliningTarget, ErrorHandlers.ErrorHandlerCache cache, TruffleString src, int pos, int len, TruffleString errors, Object mapping, ByteArrayBuilder builder, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached CharmapEncodeLookupNode charmapEncodeLookupNode, @Cached ErrorHandlers.GetErrorHandlerNode getErrorHandlerNode, @Cached ErrorHandlers.CallEncodingErrorHandlerNode callEncodingErrorHandlerNode, @Cached(inline=false) ByteArrayBuilder.AppendBytesNode appendBytesNode, @Cached CharmapEncodeOutputNode charmapEncodeOutputNode, @Cached ErrorHandlers.RaiseEncodeException raiseEncodeException) {
            int errEnd;
            for (errEnd = pos; errEnd < len; ++errEnd) {
                PEncodingMap map;
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)src, errEnd, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                if (mapping instanceof PEncodingMap ? CharmapNodes.encodingMapLookup(cp, map = (PEncodingMap)mapping) != -1 : charmapEncodeLookupNode.execute(frame, inliningTarget, cp, mapping) != PNone.NONE) break;
            }
            if (cache.errorHandlerEnum == ErrorHandlers.ErrorHandler.UNKNOWN) {
                cache.errorHandlerEnum = getErrorHandlerNode.execute(inliningTarget, errors);
            }
            ErrorHandlers.EncodingErrorHandlerResult result = callEncodingErrorHandlerNode.execute(frame, inliningTarget, cache, errors, T_CHARMAP, src, pos, errEnd, ErrorMessages.CHARACTER_MAPS_TO_UNDEFINED);
            if (!result.isUnicode) {
                appendBytesNode.execute(frame, builder, result.replacement);
                return result.newPos;
            }
            TruffleString replacement = castToTruffleStringNode.execute(inliningTarget, result.replacement);
            int repLen = codePointLengthNode.execute((AbstractTruffleString)replacement, PythonUtils.TS_ENCODING);
            for (int i = 0; i < repLen; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)replacement, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                if (charmapEncodeOutputNode.execute(frame, inliningTarget, cp, mapping, builder)) continue;
                raiseEncodeException.execute(inliningTarget, cache, T_CHARMAP, src, pos, errEnd, ErrorMessages.CHARACTER_MAPS_TO_UNDEFINED);
            }
            return result.newPos;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyUnicodeEncodeCharmapNode
    extends Node {
        public abstract byte[] execute(VirtualFrame var1, Node var2, TruffleString var3, TruffleString var4, Object var5);

        @Specialization
        static byte[] doLatin1(TruffleString src, TruffleString errors, PNone mapping, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("latin1"));
        }

        @Fallback
        static byte[] doGenericMapping(VirtualFrame frame, Node inliningTarget, TruffleString src, TruffleString errors, Object mapping, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached CharmapEncodeOutputNode charmapEncodeOutputNode, @Cached CharmapEncodingErrorNode charmapEncodingErrorNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)src, PythonUtils.TS_ENCODING);
            if (len == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayBuilder builder = new ByteArrayBuilder(len);
            int inPos = 0;
            ErrorHandlers.ErrorHandlerCache cache = new ErrorHandlers.ErrorHandlerCache();
            while (inPos < len) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)src, inPos, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                boolean x = charmapEncodeOutputNode.execute(frame, inliningTarget, cp, mapping, builder);
                if (!x) {
                    inPos = charmapEncodingErrorNode.execute(frame, inliningTarget, cache, src, inPos, len, errors, mapping, builder);
                    continue;
                }
                ++inPos;
            }
            return builder.toArray();
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyUnicodeBuildEncodingMapNode
    extends Node {
        public abstract Object execute(VirtualFrame var1, Node var2, TruffleString var3);

        @Specialization
        static Object doIt(VirtualFrame frame, Node inliningTarget, TruffleString map, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached(inline=false) HashingStorageNodes.HashingStorageSetItem setItemNode, @Cached PRaiseNode.Lazy raiseNode, @Cached(inline=false) PythonObjectFactory factory) {
            int len = Math.min(codePointLengthNode.execute((AbstractTruffleString)map, PythonUtils.TS_ENCODING), 256);
            if (len == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            byte[] level1 = new byte[32];
            byte[] level2 = new byte[512];
            int count2 = 0;
            int count3 = 0;
            Arrays.fill(level1, (byte)-1);
            Arrays.fill(level2, (byte)-1);
            if (codePointAtIndexNode.execute((AbstractTruffleString)map, 0, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT) != 0) {
                return PyUnicodeBuildEncodingMapNode.doDict(frame, inliningTarget, map, len, codePointAtIndexNode, setItemNode, factory);
            }
            for (int i = 1; i < len; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)map, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                if (cp == 0 || cp > 65535) {
                    return PyUnicodeBuildEncodingMapNode.doDict(frame, inliningTarget, map, len, codePointAtIndexNode, setItemNode, factory);
                }
                if (cp == 65534) continue;
                int l1 = cp >> 11;
                int l2 = cp >> 7;
                if (level1[l1] == -1) {
                    level1[l1] = (byte)count2++;
                }
                if (level2[l2] != -1) continue;
                level2[l2] = (byte)count3++;
            }
            if (count2 >= 255 || count3 >= 255) {
                return PyUnicodeBuildEncodingMapNode.doDict(frame, inliningTarget, map, len, codePointAtIndexNode, setItemNode, factory);
            }
            byte[] level23 = new byte[16 * count2 + 128 * count3];
            int l3Start = 16 * count2;
            Arrays.fill(level23, 0, l3Start, (byte)-1);
            count3 = 0;
            for (int i = 1; i < len; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)map, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                if (cp == 65534) continue;
                int o1 = cp >> 11;
                int o2 = cp >> 7 & 0xF;
                int i2 = 16 * (level1[o1] & 0xFF) + o2;
                if (level23[i2] == -1) {
                    level23[i2] = (byte)count3++;
                }
                int o3 = cp & 0x7F;
                int i3 = 128 * (level23[i2] & 0xFF) + o3;
                level23[l3Start + i3] = (byte)i;
            }
            return factory.createEncodingMap(count2, count3, level1, level23);
        }

        private static Object doDict(VirtualFrame frame, Node inliningTarget, TruffleString map, int len, TruffleString.CodePointAtIndexNode codePointAtIndexNode, HashingStorageNodes.HashingStorageSetItem setItemNode, PythonObjectFactory factory) {
            HashingStorage store = PDict.createNewStorage(len);
            for (int i = 0; i < len; ++i) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)map, i, PythonUtils.TS_ENCODING, TruffleString.ErrorHandling.BEST_EFFORT);
                store = setItemNode.execute((Frame)frame, inliningTarget, store, cp, i);
            }
            return factory.createDict(store);
        }
    }
}

