/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.IncrementalNewlineDecoderBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.IncrementalNewlineDecoderBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.PNLDecoder;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PIncrementalNewlineDecoder})
public final class IncrementalNewlineDecoderBuiltins
extends PythonBuiltins {
    public static final int SEEN_CR = 1;
    public static final int SEEN_LF = 2;
    public static final int SEEN_CRLF = 4;
    public static final int SEEN_ALL = 7;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IncrementalNewlineDecoderBuiltinsFactory.getFactories();
    }

    @Builtin(name="newlines", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NewlineNode
    extends PythonBuiltinNode {
        NewlineNode() {
        }

        @Specialization
        Object newline(PNLDecoder self) {
            switch (self.getSeenNewline()) {
                case 1: {
                    return StringLiterals.T_CR;
                }
                case 2: {
                    return StringLiterals.T_NEWLINE;
                }
                case 4: {
                    return StringLiterals.T_CRLF;
                }
                case 3: {
                    return this.factory().createTuple(new Object[]{StringLiterals.T_CR, StringLiterals.T_NEWLINE});
                }
                case 5: {
                    return this.factory().createTuple(new Object[]{StringLiterals.T_CR, StringLiterals.T_CRLF});
                }
                case 6: {
                    return this.factory().createTuple(new Object[]{StringLiterals.T_NEWLINE, StringLiterals.T_CRLF});
                }
                case 7: {
                    return this.factory().createTuple(new Object[]{StringLiterals.T_CR, StringLiterals.T_NEWLINE, StringLiterals.T_CRLF});
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="reset", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ResetNode
    extends PythonUnaryBuiltinNode {
        ResetNode() {
        }

        @Specialization(guards={"!self.hasDecoder()"})
        static Object noDecoder(PNLDecoder self) {
            self.setSeenNewline(0);
            self.setPendingCR(false);
            return PNone.NONE;
        }

        @Specialization(guards={"self.hasDecoder()"})
        static Object withDecoder(VirtualFrame frame, PNLDecoder self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            ResetNode.noDecoder(self);
            return callMethod.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_RESET, new Object[0]);
        }
    }

    @Builtin(name="setstate", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization(guards={"!self.hasDecoder()"})
        Object noDecoder(VirtualFrame frame, PNLDecoder self, PTuple state, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Exclusive @Cached PyIndexCheckNode indexCheckNode, @Cached.Exclusive @Cached PyNumberAsSizeNode asSizeNode) {
            Object[] objects = getObjectArrayNode.execute(inliningTarget, state);
            if (objects.length != 2 || !indexCheckNode.execute(inliningTarget, objects[1])) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ILLEGAL_STATE_ARGUMENT);
            }
            int flag = asSizeNode.executeExact((Frame)frame, inliningTarget, objects[1]);
            self.setPendingCR((flag & 1) != 0);
            return PNone.NONE;
        }

        @Specialization(guards={"self.hasDecoder()"})
        Object withDecoder(VirtualFrame frame, PNLDecoder self, PTuple state, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached.Exclusive @Cached PyIndexCheckNode indexCheckNode, @Cached.Exclusive @Cached PyNumberAsSizeNode asSizeNode, @Cached PyObjectCallMethodObjArgs callMethod) {
            Object[] objects = getObjectArrayNode.execute(inliningTarget, state);
            if (objects.length != 2 || !indexCheckNode.execute(inliningTarget, objects[1])) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ILLEGAL_STATE_ARGUMENT);
            }
            int flag = asSizeNode.executeExact((Frame)frame, inliningTarget, objects[1]);
            self.setPendingCR((flag & 1) != 0);
            PTuple tuple = this.factory().createTuple(new Object[]{objects[0], flag >>= 1});
            return callMethod.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_SETSTATE, tuple);
        }

        @Fallback
        Object err(Object self, Object state) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.STATE_ARGUMENT_MUST_BE_A_TUPLE);
        }
    }

    @Builtin(name="getstate", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetStateNode
    extends PythonUnaryBuiltinNode {
        GetStateNode() {
        }

        @Specialization(guards={"!self.hasDecoder()"})
        Object noDecoder(PNLDecoder self) {
            PBytes buffer = this.factory().createBytes(PythonUtils.EMPTY_BYTE_ARRAY);
            int flag = self.isPendingCR() ? 1 : 0;
            return this.factory().createTuple(new Object[]{buffer, flag});
        }

        @Specialization(guards={"self.hasDecoder()"})
        Object withDecoder(VirtualFrame frame, PNLDecoder self, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached PyObjectCallMethodObjArgs callMethod) {
            Object state = callMethod.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_GETSTATE, new Object[0]);
            if (!(state instanceof PTuple)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ILLEGAL_STATE_ARGUMENT);
            }
            Object[] objects = getObjectArrayNode.execute(inliningTarget, state);
            if (objects.length != 2 || !indexCheckNode.execute(inliningTarget, objects[1])) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ILLEGAL_STATE_ARGUMENT);
            }
            int flag = asSizeNode.executeExact((Frame)frame, inliningTarget, objects[1]);
            flag <<= 1;
            if (self.isPendingCR()) {
                flag |= 1;
            }
            return this.factory().createTuple(new Object[]{objects[0], flag});
        }
    }

    @Builtin(name="decode", minNumOfPositionalArgs=1, parameterNames={"$self", "input", "final"})
    @ArgumentClinic(name="final", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class DecodeNode
    extends PythonTernaryClinicBuiltinNode {
        DecodeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IncrementalNewlineDecoderBuiltinsClinicProviders.DecodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static TruffleString noDecoder(VirtualFrame frame, PNLDecoder self, Object inputIn, boolean isFinal, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile hasDecoderProfile, @Cached InlinedConditionProfile len0Profile, @Cached CastToTruffleStringNode toString, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleString.ConcatNode concatNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PyObjectCallMethodObjArgs callMethod) {
            Object input = inputIn;
            if (self.hasDecoder()) {
                hasDecoderProfile.enter(inliningTarget);
                input = callMethod.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_DECODE, input, isFinal);
            }
            TruffleString output = toString.execute(inliningTarget, input);
            int outputLen = codePointLengthNode.execute((AbstractTruffleString)output, PythonUtils.TS_ENCODING);
            if (self.isPendingCR() && (isFinal || outputLen > 0)) {
                output = concatNode.execute((AbstractTruffleString)StringLiterals.T_CR, (AbstractTruffleString)output, PythonUtils.TS_ENCODING, false);
                self.setPendingCR(false);
                ++outputLen;
            }
            if (!isFinal && outputLen > 0 && codePointAtIndexNode.execute((AbstractTruffleString)output, outputLen - 1, PythonUtils.TS_ENCODING) == 13) {
                output = substringNode.execute((AbstractTruffleString)output, 0, outputLen - 1, PythonUtils.TS_ENCODING, false);
                self.setPendingCR(true);
            }
            int len = codePointLengthNode.execute((AbstractTruffleString)output, PythonUtils.TS_ENCODING);
            int seenNewline = self.getSeenNewline();
            boolean onlyLF = false;
            if (len0Profile.profile(inliningTarget, len == 0)) {
                return output;
            }
            if (seenNewline == 2 || seenNewline == 0) {
                boolean bl = onlyLF = indexOfCodePointNode.execute((AbstractTruffleString)output, 13, 0, len, PythonUtils.TS_ENCODING) < 0;
            }
            if (onlyLF) {
                if (seenNewline == 0 && indexOfCodePointNode.execute((AbstractTruffleString)output, 10, 0, len, PythonUtils.TS_ENCODING) >= 0) {
                    seenNewline |= 2;
                }
            } else if (!self.isTranslate()) {
                if (seenNewline == 7) {
                    return output;
                }
                int i = 0;
                while (i < len && seenNewline != 7) {
                    int c;
                    while (i < len && codePointAtIndexNode.execute((AbstractTruffleString)output, i, PythonUtils.TS_ENCODING) > 13) {
                        ++i;
                    }
                    int n = c = i < len ? codePointAtIndexNode.execute((AbstractTruffleString)output, i++, PythonUtils.TS_ENCODING) : 0;
                    if (c == 10) {
                        seenNewline |= 2;
                        continue;
                    }
                    if (c != 13) continue;
                    assert (i < len || isFinal);
                    if (i < len && codePointAtIndexNode.execute((AbstractTruffleString)output, i, PythonUtils.TS_ENCODING) == 10) {
                        seenNewline |= 4;
                        ++i;
                        continue;
                    }
                    seenNewline |= 1;
                }
            } else {
                TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)output.byteLength(PythonUtils.TS_ENCODING));
                int in = 0;
                while (true) {
                    int c = 0;
                    while (in < len && (c = codePointAtIndexNode.execute((AbstractTruffleString)output, in++, PythonUtils.TS_ENCODING)) > 13) {
                        appendCodePointNode.execute(sb, c, 1, true);
                    }
                    if (c == 10) {
                        appendCodePointNode.execute(sb, c, 1, true);
                        seenNewline |= 2;
                        continue;
                    }
                    if (c == 13) {
                        if (in < len && codePointAtIndexNode.execute((AbstractTruffleString)output, in, PythonUtils.TS_ENCODING) == 10) {
                            ++in;
                            seenNewline |= 4;
                        } else {
                            seenNewline |= 1;
                        }
                        appendCodePointNode.execute(sb, 10, 1, true);
                        continue;
                    }
                    if (in >= len) break;
                    appendCodePointNode.execute(sb, c, 1, true);
                }
                output = toStringNode.execute(sb);
            }
            self.setSeenNewline(self.getSeenNewline() | seenNewline);
            return output;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2, parameterNames={"$self", "decoder", "translate", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="translate", conversion=ArgumentClinic.ClinicConversion.Boolean), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IncrementalNewlineDecoderBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone doInit(PNLDecoder self, Object decoder, boolean translate, TruffleString errors) {
            self.setDecoder(decoder);
            self.setErrors(errors);
            self.setTranslate(translate);
            self.setSeenNewline(0);
            self.setPendingCR(false);
            return PNone.NONE;
        }

        public static void internalInit(PNLDecoder self, Object decoder, boolean translate) {
            InitNode.doInit(self, decoder, translate, StringLiterals.T_STRICT);
        }
    }
}

