/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentCastNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.function.builtins.clinic.DefaultValueNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaBooleanConverterNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.JavaIntConversionNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterWithDefaultValueNode;

public class TextIOWrapperBuiltinsClinicProviders {

    public static final class ReadNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final ReadNodeClinicProviderGen INSTANCE = new ReadNodeClinicProviderGen();

        private ReadNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return JavaIntConversionNode.create(-1, true);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class WriteNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final WriteNodeClinicProviderGen INSTANCE = new WriteNodeClinicProviderGen();

        private WriteNodeClinicProviderGen() {
            super(1, 1, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return TruffleStringConverterNode.create("write");
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class TruncateNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final TruncateNodeClinicProviderGen INSTANCE = new TruncateNodeClinicProviderGen();

        private TruncateNodeClinicProviderGen() {
            super(3, 3, 3, 3, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return DefaultValueNode.create(PNone.NONE, true);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class InitNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final InitNodeClinicProviderGen INSTANCE = new InitNodeClinicProviderGen();

        private InitNodeClinicProviderGen() {
            super(99, 3, 3, 3, 124);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            switch (argIndex) {
                case 2: {
                    return TruffleStringConverterWithDefaultValueNode.create("__init__", PNone.NONE, true);
                }
                case 3: {
                    return TruffleStringConverterWithDefaultValueNode.create("__init__", StringLiterals.T_STRICT, true);
                }
                case 4: {
                    return TruffleStringConverterWithDefaultValueNode.create("__init__", PNone.NONE, true);
                }
                case 5: {
                    return JavaBooleanConverterNode.create(true, false);
                }
                case 6: {
                    return JavaBooleanConverterNode.create(true, false);
                }
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class ReadlineNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final ReadlineNodeClinicProviderGen INSTANCE = new ReadlineNodeClinicProviderGen();

        private ReadlineNodeClinicProviderGen() {
            super(1, 3, 1, 1, 2);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 1) {
                return JavaIntConversionNode.create(-1, true);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }

    public static final class SeekNodeClinicProviderGen
    extends ArgumentClinicProvider {
        public static final SeekNodeClinicProviderGen INSTANCE = new SeekNodeClinicProviderGen();

        private SeekNodeClinicProviderGen() {
            super(3, 7, 3, 3, 4);
        }

        @Override
        public ArgumentCastNode createCastNode(int argIndex, PythonBuiltinBaseNode builtin) {
            if (argIndex == 2) {
                return JavaIntConversionNode.create(0, true);
            }
            return super.createCastNode(argIndex, builtin);
        }
    }
}

