/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.common.NativeCExtSymbol;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.HashMap;

public final class NativeCAPISymbol
extends Enum<NativeCAPISymbol>
implements NativeCExtSymbol {
    public static final /* enum */ NativeCAPISymbol FUN_VA_ARG_POINTER = new NativeCAPISymbol("truffle_va_arg_pointer", ArgDescriptor.Pointer, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_CONVERT_POINTER = new NativeCAPISymbol("truffle_convert_pointer", ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_PYTRUFFLE_CONSTANTS = new NativeCAPISymbol("PyTruffle_constants", ArgDescriptor.PY_SSIZE_T_PTR, new ArgDescriptor[0]);
    public static final /* enum */ NativeCAPISymbol FUN_PYTRUFFLE_STRUCT_OFFSETS = new NativeCAPISymbol("PyTruffle_struct_offsets", ArgDescriptor.PY_SSIZE_T_PTR, new ArgDescriptor[0]);
    public static final /* enum */ NativeCAPISymbol FUN_PYTRUFFLE_STRUCT_SIZES = new NativeCAPISymbol("PyTruffle_struct_sizes", ArgDescriptor.PY_SSIZE_T_PTR, new ArgDescriptor[0]);
    public static final /* enum */ NativeCAPISymbol FUN_PYTRUFFLE_ADD_OFFSET = new NativeCAPISymbol("PyTruffle_Add_Offset", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Long);
    public static final /* enum */ NativeCAPISymbol FUN_READ_SHORT_MEMBER = new NativeCAPISymbol("ReadShortMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_INT_MEMBER = new NativeCAPISymbol("ReadIntMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_LONG_MEMBER = new NativeCAPISymbol("ReadLongMember", ArgDescriptor.Long, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_FLOAT_MEMBER = new NativeCAPISymbol("ReadFloatMember", ArgDescriptor.Double, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_DOUBLE_MEMBER = new NativeCAPISymbol("ReadDoubleMember", ArgDescriptor.Double, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_STRING_MEMBER = new NativeCAPISymbol("ReadStringMember", ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_STRING_IN_PLACE_MEMBER = new NativeCAPISymbol("ReadStringInPlaceMember", ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_OBJECT_MEMBER = new NativeCAPISymbol("ReadObjectMember", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_POINTER_MEMBER = new NativeCAPISymbol("ReadPointerMember", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_OBJECT_EX_MEMBER = new NativeCAPISymbol("ReadObjectExMember", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_CHAR_MEMBER = new NativeCAPISymbol("ReadCharMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_UBYTE_MEMBER = new NativeCAPISymbol("ReadUByteMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_USHORT_MEMBER = new NativeCAPISymbol("ReadUShortMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_UINT_MEMBER = new NativeCAPISymbol("ReadUIntMember", ArgDescriptor.Long, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_ULONG_MEMBER = new NativeCAPISymbol("ReadULongMember", ArgDescriptor.UNSIGNED_LONG, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_LONGLONG_MEMBER = new NativeCAPISymbol("ReadLongLongMember", ArgDescriptor.LONG_LONG, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_ULONGLONG_MEMBER = new NativeCAPISymbol("ReadULongLongMember", ArgDescriptor.UNSIGNED_LONG_LONG, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_READ_PYSSIZET_MEMBER = new NativeCAPISymbol("ReadPySSizeT", ArgDescriptor.Py_ssize_t, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_SHORT_MEMBER = new NativeCAPISymbol("WriteShortMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_INT_MEMBER = new NativeCAPISymbol("WriteIntMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_LONG_MEMBER = new NativeCAPISymbol("WriteLongMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Long);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_FLOAT_MEMBER = new NativeCAPISymbol("WriteFloatMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Double);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_DOUBLE_MEMBER = new NativeCAPISymbol("WriteDoubleMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Double);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_STRING_MEMBER = new NativeCAPISymbol("WriteStringMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.ConstCharPtr);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_STRING_IN_PLACE_MEMBER = new NativeCAPISymbol("WriteStringInPlaceMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.ConstCharPtr);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_OBJECT_MEMBER = new NativeCAPISymbol("WriteObjectMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_OBJECT_EX_MEMBER = new NativeCAPISymbol("WriteObjectExMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_CHAR_MEMBER = new NativeCAPISymbol("WriteCharMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_UBYTE_MEMBER = new NativeCAPISymbol("WriteUByteMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_USHORT_MEMBER = new NativeCAPISymbol("WriteUShortMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_UINT_MEMBER = new NativeCAPISymbol("WriteUIntMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.UNSIGNED_INT);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_ULONG_MEMBER = new NativeCAPISymbol("WriteULongMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.UNSIGNED_LONG);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_LONGLONG_MEMBER = new NativeCAPISymbol("WriteLongLongMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.LONG_LONG);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_ULONGLONG_MEMBER = new NativeCAPISymbol("WriteULongLongMember", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.UNSIGNED_LONG_LONG);
    public static final /* enum */ NativeCAPISymbol FUN_WRITE_PYSSIZET_MEMBER = new NativeCAPISymbol("WritePySSizeT", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_GET_METHODS_FLAGS = new NativeCAPISymbol("get_methods_flags", ArgDescriptor.INT64_T, ArgDescriptor.PyTypeObject);
    public static final /* enum */ NativeCAPISymbol FUN_PTR_COMPARE = new NativeCAPISymbol("truffle_ptr_compare", ArgDescriptor.Int, ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_PTR_ADD = new NativeCAPISymbol("truffle_ptr_add", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_OBJECT_ARRAY_RELEASE = new NativeCAPISymbol("PyTruffle_ObjectArrayRelease", ArgDescriptor.Void, ArgDescriptor.Pointer, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_SET_STORAGE_ITEM = new NativeCAPISymbol("PyTruffle_SetStorageItem", ArgDescriptor.Void, ArgDescriptor.Pointer, ArgDescriptor.Int, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_INITIALIZE_STORAGE_ITEM = new NativeCAPISymbol("PyTruffle_InitializeStorageItem", ArgDescriptor.Void, ArgDescriptor.Pointer, ArgDescriptor.Int, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_OBJECT_GENERIC_GET_DICT = new NativeCAPISymbol("_PyObject_GenericGetDict", ArgDescriptor.PyObject, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_OBJECT_GENERIC_SET_DICT = new NativeCAPISymbol("PyObject_GenericSetDict", ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_PY_OBJECT_NEW = new NativeCAPISymbol("PyTruffle_Object_New", ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject);
    public static final /* enum */ NativeCAPISymbol FUN_ADD_NATIVE_SLOTS = new NativeCAPISymbol("PyTruffle_Type_AddSlots", ArgDescriptor.Void, ArgDescriptor.PyTypeObject, ArgDescriptor.Pointer, ArgDescriptor.UINT64_T, ArgDescriptor.Pointer, ArgDescriptor.UINT64_T);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TYPE_READY = new NativeCAPISymbol("PyType_Ready", ArgDescriptor.Int, ArgDescriptor.PyTypeObject);
    public static final /* enum */ NativeCAPISymbol FUN_GET_BUFFER_R = new NativeCAPISymbol("get_buffer_r", ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_GET_BUFFER_RW = new NativeCAPISymbol("get_buffer_rw", ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_CONVERTBUFFER = new NativeCAPISymbol("convertbuffer", ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_PY_UNICODE_GET_LENGTH = new NativeCAPISymbol("PyUnicode_GetLength", ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_FREE = new NativeCAPISymbol("PyTruffle_Free", ArgDescriptor.Void, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_PYMEM_ALLOC = new NativeCAPISymbol("PyMem_Calloc", ArgDescriptor.Pointer, ArgDescriptor.SIZE_T, ArgDescriptor.SIZE_T);
    public static final /* enum */ NativeCAPISymbol FUN_INCREF = new NativeCAPISymbol("Py_IncRef", ArgDescriptor.Void, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_DECREF = new NativeCAPISymbol("Py_DecRef", ArgDescriptor.Void, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_ADDREF = new NativeCAPISymbol("PyTruffle_ADDREF", ArgDescriptor.Py_ssize_t, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_SUBREF = new NativeCAPISymbol("PyTruffle_SUBREF", ArgDescriptor.Py_ssize_t, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_BULK_DEALLOC = new NativeCAPISymbol("PyTruffle_bulk_DEALLOC", ArgDescriptor.Py_ssize_t, ArgDescriptor.Pointer, ArgDescriptor.INT64_T);
    public static final /* enum */ NativeCAPISymbol FUN_TRUFFLE_ADD_SUBOFFSET = new NativeCAPISymbol("truffle_add_suboffset", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_PY_MAPPING_CHECK = new NativeCAPISymbol("PyTruffle_PyMapping_Check", ArgDescriptor.Int, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_PY_MAPPING_SIZE = new NativeCAPISymbol("PyTruffle_PyMapping_Size", ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_MEMORYVIEW_FROM_OBJECT = new NativeCAPISymbol("PyTruffle_MemoryViewFromObject", ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_PY_OBJECT_SIZE = new NativeCAPISymbol("PyTruffle_PyObject_Size", ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_RELEASE_BUFFER = new NativeCAPISymbol("PyTruffle_ReleaseBuffer", ArgDescriptor.Void, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_PY_SEQUENCE_CHECK = new NativeCAPISymbol("PyTruffle_PySequence_Check", ArgDescriptor.Int, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_PY_SEQUENCE_SIZE = new NativeCAPISymbol("PyTruffle_PySequence_Size", ArgDescriptor.Py_ssize_t, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_PY_TRUFFLE_PY_SEQUENCE_GET_ITEM = new NativeCAPISymbol("PyTruffle_PySequence_GetItem", ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_TUPLE_SUBTYPE_NEW = new NativeCAPISymbol("tuple_subtype_new", ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_BYTES_SUBTYPE_NEW = new NativeCAPISymbol("bytes_subtype_new", ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject, ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t);
    public static final /* enum */ NativeCAPISymbol FUN_FLOAT_SUBTYPE_NEW = new NativeCAPISymbol("float_subtype_new", ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject, ArgDescriptor.Double);
    public static final /* enum */ NativeCAPISymbol FUN_EXCEPTION_SUBTYPE_NEW = new NativeCAPISymbol("exception_subtype_new", ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_SUBCLASS_CHECK = new NativeCAPISymbol("truffle_subclass_check", ArgDescriptor.Int, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_BASETYPE_CHECK = new NativeCAPISymbol("truffle_BASETYPE_check", ArgDescriptor.Int, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_MEMCPY_BYTES = new NativeCAPISymbol("truffle_memcpy_bytes", ArgDescriptor.Void, ArgDescriptor.Pointer, ArgDescriptor.SIZE_T, ArgDescriptor.Pointer, ArgDescriptor.SIZE_T, ArgDescriptor.SIZE_T);
    public static final /* enum */ NativeCAPISymbol FUN_UNICODE_SUBTYPE_NEW = new NativeCAPISymbol("unicode_subtype_new", ArgDescriptor.PyObject, ArgDescriptor.PyTypeObject, ArgDescriptor.PyObject);
    public static final /* enum */ NativeCAPISymbol FUN_CHECK_BASESIZE_FOR_GETSTATE = new NativeCAPISymbol("tuffle_check_basesize_for_getstate", ArgDescriptor.Int, ArgDescriptor.PyTypeObject, ArgDescriptor.Int);
    public static final /* enum */ NativeCAPISymbol FUN_MMAP_INIT_BUFFERPROTOCOL = new NativeCAPISymbol("mmap_init_bufferprotocol", ArgDescriptor.Void, ArgDescriptor.PyTypeObject);
    public static final /* enum */ NativeCAPISymbol FUN_TRUFFLE_CHECK_TYPE_READY = new NativeCAPISymbol("truffle_check_type_ready", ArgDescriptor.Void, ArgDescriptor.PyTypeObject);
    public static final /* enum */ NativeCAPISymbol FUN_SET_PY_DATETIME_TYPES = new NativeCAPISymbol("set_PyDateTime_types", ArgDescriptor.Void, new ArgDescriptor[0]);
    public static final /* enum */ NativeCAPISymbol FUN_STRLEN = new NativeCAPISymbol("strlen", ArgDescriptor.SIZE_T, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_MEMCPY = new NativeCAPISymbol("memcpy", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.SIZE_T);
    public static final /* enum */ NativeCAPISymbol FUN_FREE = new NativeCAPISymbol("truffle_free", ArgDescriptor.Int, ArgDescriptor.Pointer);
    public static final /* enum */ NativeCAPISymbol FUN_MEMMOVE = new NativeCAPISymbol("memmove", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.SIZE_T);
    public static final /* enum */ NativeCAPISymbol FUN_MEMSET = new NativeCAPISymbol("memset", ArgDescriptor.Pointer, ArgDescriptor.Pointer, ArgDescriptor.Int, ArgDescriptor.SIZE_T);
    public static final /* enum */ NativeCAPISymbol FUN_CALLOC = new NativeCAPISymbol("truffle_calloc", ArgDescriptor.Pointer, ArgDescriptor.SIZE_T);
    public static final /* enum */ NativeCAPISymbol FUN_STRING_AT = new NativeCAPISymbol("string_at");
    public static final /* enum */ NativeCAPISymbol FUN_CAST = new NativeCAPISymbol("cast");
    public static final /* enum */ NativeCAPISymbol FUN_WSTRING_AT = new NativeCAPISymbol("wstring_at");
    private final String name;
    private final TruffleString tsName;
    private final ArgDescriptor returnValue;
    private final ArgDescriptor[] arguments;
    private final String signature;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final NativeCAPISymbol[] VALUES;
    private static final HashMap<String, NativeCAPISymbol> MAP;
    private static final /* synthetic */ NativeCAPISymbol[] $VALUES;

    public static NativeCAPISymbol[] values() {
        return (NativeCAPISymbol[])$VALUES.clone();
    }

    public static NativeCAPISymbol valueOf(String name) {
        return Enum.valueOf(NativeCAPISymbol.class, name);
    }

    private NativeCAPISymbol(String name, ArgDescriptor returnValue, ArgDescriptor ... arguments) {
        this.name = name;
        this.tsName = PythonUtils.toTruffleStringUncached(name);
        this.returnValue = returnValue;
        this.arguments = arguments;
        StringBuilder s = new StringBuilder("(");
        for (int i = 0; i < arguments.length; ++i) {
            s.append(i == 0 ? "" : ",");
            s.append(arguments[i].getNFISignature());
        }
        s.append("):").append(returnValue.getNFISignature());
        this.signature = s.toString();
    }

    private NativeCAPISymbol(String name) {
        this.name = name;
        this.tsName = PythonUtils.toTruffleStringUncached(name);
        this.returnValue = null;
        this.arguments = null;
        this.signature = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TruffleString getTsName() {
        return this.tsName;
    }

    public static NativeCAPISymbol getByName(String name) {
        CompilerAsserts.neverPartOfCompilation();
        return MAP.get(name);
    }

    public static NativeCAPISymbol[] getValues() {
        return VALUES;
    }

    @Override
    public String getSignature() {
        assert (this.signature != null) : "no signature for " + this;
        return this.signature;
    }

    private static /* synthetic */ NativeCAPISymbol[] $values() {
        return new NativeCAPISymbol[]{FUN_VA_ARG_POINTER, FUN_CONVERT_POINTER, FUN_PYTRUFFLE_CONSTANTS, FUN_PYTRUFFLE_STRUCT_OFFSETS, FUN_PYTRUFFLE_STRUCT_SIZES, FUN_PYTRUFFLE_ADD_OFFSET, FUN_READ_SHORT_MEMBER, FUN_READ_INT_MEMBER, FUN_READ_LONG_MEMBER, FUN_READ_FLOAT_MEMBER, FUN_READ_DOUBLE_MEMBER, FUN_READ_STRING_MEMBER, FUN_READ_STRING_IN_PLACE_MEMBER, FUN_READ_OBJECT_MEMBER, FUN_READ_POINTER_MEMBER, FUN_READ_OBJECT_EX_MEMBER, FUN_READ_CHAR_MEMBER, FUN_READ_UBYTE_MEMBER, FUN_READ_USHORT_MEMBER, FUN_READ_UINT_MEMBER, FUN_READ_ULONG_MEMBER, FUN_READ_LONGLONG_MEMBER, FUN_READ_ULONGLONG_MEMBER, FUN_READ_PYSSIZET_MEMBER, FUN_WRITE_SHORT_MEMBER, FUN_WRITE_INT_MEMBER, FUN_WRITE_LONG_MEMBER, FUN_WRITE_FLOAT_MEMBER, FUN_WRITE_DOUBLE_MEMBER, FUN_WRITE_STRING_MEMBER, FUN_WRITE_STRING_IN_PLACE_MEMBER, FUN_WRITE_OBJECT_MEMBER, FUN_WRITE_OBJECT_EX_MEMBER, FUN_WRITE_CHAR_MEMBER, FUN_WRITE_UBYTE_MEMBER, FUN_WRITE_USHORT_MEMBER, FUN_WRITE_UINT_MEMBER, FUN_WRITE_ULONG_MEMBER, FUN_WRITE_LONGLONG_MEMBER, FUN_WRITE_ULONGLONG_MEMBER, FUN_WRITE_PYSSIZET_MEMBER, FUN_GET_METHODS_FLAGS, FUN_PTR_COMPARE, FUN_PTR_ADD, FUN_PY_TRUFFLE_OBJECT_ARRAY_RELEASE, FUN_PY_TRUFFLE_SET_STORAGE_ITEM, FUN_PY_TRUFFLE_INITIALIZE_STORAGE_ITEM, FUN_PY_OBJECT_GENERIC_GET_DICT, FUN_PY_OBJECT_GENERIC_SET_DICT, FUN_PY_OBJECT_NEW, FUN_ADD_NATIVE_SLOTS, FUN_PY_TYPE_READY, FUN_GET_BUFFER_R, FUN_GET_BUFFER_RW, FUN_CONVERTBUFFER, FUN_PY_UNICODE_GET_LENGTH, FUN_PY_TRUFFLE_FREE, FUN_PYMEM_ALLOC, FUN_INCREF, FUN_DECREF, FUN_ADDREF, FUN_SUBREF, FUN_BULK_DEALLOC, FUN_TRUFFLE_ADD_SUBOFFSET, FUN_PY_TRUFFLE_PY_MAPPING_CHECK, FUN_PY_TRUFFLE_PY_MAPPING_SIZE, FUN_PY_TRUFFLE_MEMORYVIEW_FROM_OBJECT, FUN_PY_TRUFFLE_PY_OBJECT_SIZE, FUN_PY_TRUFFLE_RELEASE_BUFFER, FUN_PY_TRUFFLE_PY_SEQUENCE_CHECK, FUN_PY_TRUFFLE_PY_SEQUENCE_SIZE, FUN_PY_TRUFFLE_PY_SEQUENCE_GET_ITEM, FUN_TUPLE_SUBTYPE_NEW, FUN_BYTES_SUBTYPE_NEW, FUN_FLOAT_SUBTYPE_NEW, FUN_EXCEPTION_SUBTYPE_NEW, FUN_SUBCLASS_CHECK, FUN_BASETYPE_CHECK, FUN_MEMCPY_BYTES, FUN_UNICODE_SUBTYPE_NEW, FUN_CHECK_BASESIZE_FOR_GETSTATE, FUN_MMAP_INIT_BUFFERPROTOCOL, FUN_TRUFFLE_CHECK_TYPE_READY, FUN_SET_PY_DATETIME_TYPES, FUN_STRLEN, FUN_MEMCPY, FUN_FREE, FUN_MEMMOVE, FUN_MEMSET, FUN_CALLOC, FUN_STRING_AT, FUN_CAST, FUN_WSTRING_AT};
    }

    static {
        $VALUES = NativeCAPISymbol.$values();
        VALUES = NativeCAPISymbol.values();
        MAP = new HashMap();
        for (NativeCAPISymbol symbol : VALUES) {
            assert (!MAP.containsKey(symbol.name));
            MAP.put(symbol.name, symbol);
        }
    }
}

