/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public abstract class PythonNativeWrapper
implements TruffleObject {
    public static final long MANAGED_REFCNT = 10L;
    public static final long IMMORTAL_REFCNT = 65536L;
    private static final long UNINITIALIZED = -1L;
    private Object delegate;
    private long nativePointer = -1L;
    private long refCount = 10L;
    public CApiTransitions.PythonObjectReference ref;

    public PythonNativeWrapper() {
    }

    public PythonNativeWrapper(Object delegate) {
        this.delegate = delegate;
    }

    public final long getRefCount() {
        return this.refCount;
    }

    public final void setRefCount(long refCount) {
        this.refCount = refCount;
    }

    public final Object getDelegate() {
        return this.delegate;
    }

    protected final void setDelegate(Object delegate) {
        assert (this.delegate == null || this.delegate == delegate);
        this.delegate = delegate;
    }

    public final long getNativePointer() {
        return this.nativePointer;
    }

    public final void setNativePointer(long nativePointer) {
        assert (this.nativePointer == -1L || this.nativePointer == nativePointer || nativePointer == -1L);
        this.nativePointer = nativePointer;
    }

    public final boolean isNative(Node inliningTarget, InlinedConditionProfile hasNativePointerProfile) {
        return hasNativePointerProfile.profile(inliningTarget, this.nativePointer != -1L);
    }

    public final boolean isNative() {
        return this.nativePointer != -1L;
    }
}

