/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@TypeSystemReference(value=PythonArithmeticTypes.class)
@ImportStatic(value={MathGuards.class})
public abstract class CoerceToComplexNode
extends PNodeWithRaise {
    @Node.Child
    private LookupAndCallUnaryNode callComplexFunc;

    public abstract PComplex execute(VirtualFrame var1, Object var2);

    @Specialization
    PComplex toComplex(long x, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
        return factory.createComplex(x, 0.0);
    }

    @Specialization
    PComplex toComplex(double x, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
        return factory.createComplex(x, 0.0);
    }

    @Specialization
    PComplex toComplex(VirtualFrame frame, Object x, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile complexProfile, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
        Object result;
        if (complexProfile.profile(inliningTarget, x instanceof PComplex)) {
            return (PComplex)x;
        }
        if (this.callComplexFunc == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callComplexFunc = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodNames.T___COMPLEX__));
        }
        if ((result = this.callComplexFunc.executeObject(frame, x)) != PNone.NO_VALUE) {
            if (result instanceof PComplex) {
                return (PComplex)result;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_RETURN, "__complex__", "complex object");
        }
        return factory.createComplex(asDoubleNode.execute(frame, inliningTarget, x), 0.0);
    }
}

