/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.EmptySequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;

public abstract class SequenceStorageFactory {
    private SequenceStorageFactory() {
    }

    public static SequenceStorage createStorage(Object[] values) {
        assert (values != null);
        assert (values.getClass() == Object[].class) : "cannot use non-Object array for modifiable list";
        if (values.length == 0) {
            return EmptySequenceStorage.INSTANCE;
        }
        if (SequenceStorageFactory.canSpecializeToInt(values)) {
            return new IntSequenceStorage(SequenceStorageFactory.specializeToInt(values));
        }
        if (SequenceStorageFactory.canSpecializeToDouble(values)) {
            return new DoubleSequenceStorage(SequenceStorageFactory.specializeToDouble(values));
        }
        if (SequenceStorageFactory.canSpecializeToLong(values)) {
            return new LongSequenceStorage(SequenceStorageFactory.specializeToLong(values));
        }
        if (SequenceStorageFactory.canSpecializeToBool(values)) {
            return new BoolSequenceStorage(SequenceStorageFactory.specializeToBool(values));
        }
        if (SequenceStorageFactory.canSpecializeToByte(values)) {
            return new ByteSequenceStorage(SequenceStorageFactory.specializeToByte(values));
        }
        return new ObjectSequenceStorage(values);
    }

    public static BasicSequenceStorage createStorage(Object baseValue, int len) {
        assert (baseValue != null);
        if (baseValue instanceof Integer) {
            return new IntSequenceStorage(len);
        }
        if (baseValue instanceof Byte) {
            return new ByteSequenceStorage(len);
        }
        if (baseValue instanceof Long) {
            return new LongSequenceStorage(len);
        }
        if (baseValue instanceof Double) {
            return new DoubleSequenceStorage(len);
        }
        if (baseValue instanceof Boolean) {
            return new BoolSequenceStorage(len);
        }
        return new ObjectSequenceStorage(len);
    }

    private static boolean canSpecializeToInt(Object[] values) {
        for (Object item : values) {
            if (item instanceof Integer) continue;
            return false;
        }
        return true;
    }

    private static int[] specializeToInt(Object[] values) {
        int[] intVals = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            intVals[i] = (Integer)values[i];
        }
        return intVals;
    }

    private static boolean canSpecializeToByte(Object[] values) {
        for (Object item : values) {
            if (item instanceof Byte) continue;
            return false;
        }
        return true;
    }

    private static byte[] specializeToByte(Object[] values) {
        byte[] byteVals = new byte[values.length];
        for (int i = 0; i < values.length; ++i) {
            byteVals[i] = (Byte)values[i];
        }
        return byteVals;
    }

    private static boolean canSpecializeToLong(Object[] values) {
        for (Object item : values) {
            if (item instanceof Long || item instanceof Integer) continue;
            return false;
        }
        return true;
    }

    private static long[] specializeToLong(Object[] values) {
        long[] intVals = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            long value;
            intVals[i] = value = values[i] instanceof Integer ? (long)((Integer)values[i]).intValue() : (Long)values[i];
        }
        return intVals;
    }

    private static boolean canSpecializeToDouble(Object[] values) {
        for (Object item : values) {
            if (item instanceof Double) continue;
            return false;
        }
        return true;
    }

    private static double[] specializeToDouble(Object[] values) {
        double[] doubles = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubles[i] = (Double)values[i];
        }
        return doubles;
    }

    private static boolean canSpecializeToBool(Object[] values) {
        for (Object item : values) {
            if (item instanceof Boolean) continue;
            return false;
        }
        return true;
    }

    private static boolean[] specializeToBool(Object[] values) {
        boolean[] bools = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            bools[i] = (Boolean)values[i];
        }
        return bools;
    }
}

