/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.definition.table;

import org.atp.spi.TypeableImpl;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.datatypes.SQLDataType;
import org.sql.generation.api.grammar.definition.table.AutoGenerationPolicy;
import org.sql.generation.api.grammar.definition.table.ColumnDefinition;
import org.sql.generation.api.grammar.definition.table.TableElement;
import org.sql.generation.implementation.grammar.common.SQLSyntaxElementBase;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnDefinitionImpl
extends SQLSyntaxElementBase<TableElement, ColumnDefinition>
implements ColumnDefinition {
    private final String _name;
    private final SQLDataType _dataType;
    private final String _default;
    private final Boolean _mayBeNull;
    private final AutoGenerationPolicy _autoGenerationPolicy;

    public ColumnDefinitionImpl(SQLProcessorAggregator processor, String name, SQLDataType dataType, String defaultStr, Boolean mayBeNull, AutoGenerationPolicy autoGenerationPolicy) {
        this(processor, ColumnDefinition.class, name, dataType, defaultStr, mayBeNull, autoGenerationPolicy);
    }

    protected ColumnDefinitionImpl(SQLProcessorAggregator processor, Class<? extends ColumnDefinition> realImplementingType, String name, SQLDataType dataType, String defaultStr, Boolean mayBeNull, AutoGenerationPolicy autoGenerationPolicy) {
        super(processor, realImplementingType);
        NullArgumentException.validateNotNull((String)"Column name", (Object)name);
        NullArgumentException.validateNotNull((String)"Column data type", (Object)dataType);
        NullArgumentException.validateNotNull((String)"Null policy", (Object)mayBeNull);
        this._name = name;
        this._dataType = dataType;
        this._default = defaultStr;
        this._mayBeNull = mayBeNull;
        this._autoGenerationPolicy = autoGenerationPolicy;
    }

    protected boolean doesEqual(ColumnDefinition another) {
        return this._name.equals(another.getColumnName()) && this._dataType.equals(another.getDataType()) && TypeableImpl.bothNullOrEquals((Object)this._default, (Object)another.getDefault()) && this._mayBeNull.equals(another.mayBeNull());
    }

    public String getColumnName() {
        return this._name;
    }

    public SQLDataType getDataType() {
        return this._dataType;
    }

    public String getDefault() {
        return this._default;
    }

    public Boolean mayBeNull() {
        return this._mayBeNull;
    }

    public AutoGenerationPolicy getAutoGenerationPolicy() {
        return this._autoGenerationPolicy;
    }
}

