/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generation.implementation.grammar.literals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sql.generation.api.common.NullArgumentException;
import org.sql.generation.api.grammar.common.ValueExpression;
import org.sql.generation.api.grammar.literals.SQLFunctionLiteral;
import org.sql.generation.implementation.grammar.common.NonBooleanExpressionImpl;
import org.sql.generation.implementation.transformation.spi.SQLProcessorAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLFunctionLiteralImpl
extends NonBooleanExpressionImpl<SQLFunctionLiteral>
implements SQLFunctionLiteral {
    private final String _name;
    private final List<ValueExpression> _parameters;

    public SQLFunctionLiteralImpl(SQLProcessorAggregator processor, String name, ValueExpression ... parameters) {
        this(processor, name, Arrays.asList(parameters));
    }

    public SQLFunctionLiteralImpl(SQLProcessorAggregator processor, String name, List<ValueExpression> parameters) {
        this(processor, SQLFunctionLiteral.class, name, parameters);
    }

    protected SQLFunctionLiteralImpl(SQLProcessorAggregator processor, Class<? extends SQLFunctionLiteral> implClass, String name, List<ValueExpression> parameters) {
        super(processor, implClass);
        NullArgumentException.validateNotNull((String)"name", (Object)name);
        NullArgumentException.validateNotNull((String)"parameters", parameters);
        for (ValueExpression exp : parameters) {
            NullArgumentException.validateNotNull((String)"parameter", (Object)exp);
        }
        this._name = name;
        this._parameters = Collections.unmodifiableList(new ArrayList<ValueExpression>(parameters));
    }

    public String getFunctionName() {
        return this._name;
    }

    public List<ValueExpression> getParameters() {
        return this._parameters;
    }

    protected boolean doesEqual(SQLFunctionLiteral another) {
        return this._name.equals(another.getFunctionName()) && ((Object)this._parameters).equals(another.getParameters());
    }
}

