/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.example;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collections;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class AutobahnServerTest
extends WebSocketServer {
    private static int openCounter = 0;
    private static int closeCounter = 0;
    private int limit = Integer.MAX_VALUE;

    public AutobahnServerTest(int port, int limit, Draft d) throws UnknownHostException {
        super(new InetSocketAddress(port), Collections.singletonList(d));
        this.limit = limit;
    }

    public AutobahnServerTest(InetSocketAddress address, Draft d) {
        super(address, Collections.singletonList(d));
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        System.out.println("///////////Opened connection number" + ++openCounter);
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        System.out.println("closed");
        if (++closeCounter >= this.limit) {
            System.exit(0);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        System.out.println("Error:");
        ex.printStackTrace();
    }

    public void onStart() {
        System.out.println("Server started!");
    }

    public void onMessage(WebSocket conn, String message) {
        conn.send(message);
    }

    public void onMessage(WebSocket conn, ByteBuffer blob) {
        conn.send(blob);
    }

    public static void main(String[] args) throws UnknownHostException {
        int limit;
        int port;
        try {
            port = new Integer(args[0]);
        }
        catch (Exception e) {
            System.out.println("No port specified. Defaulting to 9003");
            port = 9003;
        }
        try {
            limit = new Integer(args[1]);
        }
        catch (Exception e) {
            System.out.println("No limit specified. Defaulting to MaxInteger");
            limit = Integer.MAX_VALUE;
        }
        AutobahnServerTest test = new AutobahnServerTest(port, limit, (Draft)new Draft_6455());
        test.setConnectionLostTimeout(0);
        test.start();
    }
}

