/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.issues;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.SocketUtil;
import org.junit.Test;

public class Issue811Test {
    private CountDownLatch countServerDownLatch = new CountDownLatch(1);

    @Test(timeout=2000L)
    public void testSetConnectionLostTimeout() throws IOException, InterruptedException {
        final MyWebSocketServer server = new MyWebSocketServer(new InetSocketAddress(SocketUtil.getAvailablePort()));
        server.start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (server.getConnectionLostTimeout() == 60) {
                }
                Issue811Test.this.countServerDownLatch.countDown();
            }
        }).start();
        Thread.sleep(1000L);
        server.setConnectionLostTimeout(20);
        this.countServerDownLatch.await();
    }

    private static class MyWebSocketServer
    extends WebSocketServer {
        public MyWebSocketServer(InetSocketAddress inetSocketAddress) {
            super(inetSocketAddress);
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        }

        public void onMessage(WebSocket conn, String message) {
        }

        public void onError(WebSocket conn, Exception ex) {
        }

        public void onStart() {
        }
    }
}

