/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;

public class TypeConversion
extends ModelElement
implements Assignment {
    private static final String SOURCE_REFERENCE_PATTERN = "<SOURCE>";
    private final Set<Type> importTypes;
    private final List<Type> thrownTypes;
    private final String openExpression;
    private final String closeExpression;
    private Assignment assignment;

    public TypeConversion(Set<Type> importTypes, List<Type> exceptionTypes, String expression) {
        this.importTypes = new HashSet<Type>(importTypes);
        this.importTypes.addAll(exceptionTypes);
        this.thrownTypes = exceptionTypes;
        int patternIndex = expression.indexOf(SOURCE_REFERENCE_PATTERN);
        this.openExpression = expression.substring(0, patternIndex);
        this.closeExpression = expression.substring(patternIndex + 8);
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.importTypes;
    }

    @Override
    public List<Type> getThrownTypes() {
        return this.thrownTypes;
    }

    public String getOpenExpression() {
        return this.openExpression;
    }

    public String getCloseExpression() {
        return this.closeExpression;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public String getSourceReference() {
        return this.assignment.getSourceReference();
    }

    @Override
    public boolean isSourceReferenceParameter() {
        return this.assignment.isSourceReferenceParameter();
    }

    @Override
    public String getSourcePresenceCheckerReference() {
        return this.assignment.getSourcePresenceCheckerReference();
    }

    @Override
    public Type getSourceType() {
        return this.assignment.getSourceType();
    }

    @Override
    public String createUniqueVarName(String desiredName) {
        return this.assignment.createUniqueVarName(desiredName);
    }

    @Override
    public String getSourceLocalVarName() {
        return this.assignment.getSourceLocalVarName();
    }

    @Override
    public void setSourceLocalVarName(String sourceLocalVarName) {
        this.assignment.setSourceLocalVarName(sourceLocalVarName);
    }

    @Override
    public String getSourceLoopVarName() {
        return this.assignment.getSourceLoopVarName();
    }

    @Override
    public void setSourceLoopVarName(String sourceLoopVarName) {
        this.assignment.setSourceLoopVarName(sourceLoopVarName);
    }

    @Override
    public String getSourceParameterName() {
        return this.assignment.getSourceParameterName();
    }

    @Override
    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    @Override
    public Assignment.AssignmentType getType() {
        switch (this.assignment.getType()) {
            case DIRECT: {
                return Assignment.AssignmentType.TYPE_CONVERTED;
            }
            case MAPPED: {
                return Assignment.AssignmentType.MAPPED_TYPE_CONVERTED;
            }
        }
        return null;
    }

    @Override
    public boolean isCallingUpdateMethod() {
        return false;
    }
}

