/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;

public class Field
extends ModelElement {
    private final Type type;
    private final String variableName;
    private boolean used;
    private boolean typeRequiresImport;

    public Field(Type type, String variableName, boolean used) {
        this.type = type;
        this.variableName = variableName;
        this.used = used;
        this.typeRequiresImport = used;
    }

    public Field(Type type, String variableName) {
        this.type = type;
        this.variableName = variableName;
        this.used = false;
        this.typeRequiresImport = false;
    }

    public Type getType() {
        return this.type;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return Collections.emptySet();
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean isUsed) {
        this.used = isUsed;
    }

    public boolean isTypeRequiresImport() {
        return this.typeRequiresImport;
    }

    public void setTypeRequiresImport(boolean typeRequiresImport) {
        this.typeRequiresImport = typeRequiresImport;
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (this.variableName != null ? this.variableName.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        return Objects.equals(this.variableName, other.variableName);
    }

    public static List<String> getFieldNames(Set<Field> fields) {
        ArrayList<String> names = new ArrayList<String>(fields.size());
        for (Field field : fields) {
            names.add(field.getVariableName());
        }
        return names;
    }
}

