/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.assignment;

import java.util.ArrayList;
import java.util.List;
import org.mapstruct.ap.internal.gem.NullValueCheckStrategyGem;
import org.mapstruct.ap.internal.gem.NullValuePropertyMappingStrategyGem;
import org.mapstruct.ap.internal.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.Type;

public class SetterWrapper
extends AssignmentWrapper {
    private final List<Type> thrownTypesToExclude;
    private final boolean includeSourceNullCheck;
    private final boolean setExplicitlyToNull;
    private final boolean setExplicitlyToDefault;

    public SetterWrapper(Assignment rhs, List<Type> thrownTypesToExclude, boolean fieldAssignment, boolean includeSourceNullCheck, boolean setExplicitlyToNull, boolean setExplicitlyToDefault) {
        super(rhs, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.includeSourceNullCheck = includeSourceNullCheck;
        this.setExplicitlyToDefault = setExplicitlyToDefault;
        this.setExplicitlyToNull = setExplicitlyToNull;
    }

    public SetterWrapper(Assignment rhs, List<Type> thrownTypesToExclude, boolean fieldAssignment) {
        super(rhs, fieldAssignment);
        this.thrownTypesToExclude = thrownTypesToExclude;
        this.includeSourceNullCheck = false;
        this.setExplicitlyToNull = false;
        this.setExplicitlyToDefault = false;
    }

    @Override
    public List<Type> getThrownTypes() {
        List<Type> parentThrownTypes = super.getThrownTypes();
        ArrayList<Type> result = new ArrayList<Type>(parentThrownTypes);
        for (Type thrownTypeToExclude : this.thrownTypesToExclude) {
            for (Type parentThrownType : parentThrownTypes) {
                if (!parentThrownType.isAssignableTo(thrownTypeToExclude)) continue;
                result.remove(parentThrownType);
            }
        }
        return result;
    }

    public boolean isSetExplicitlyToNull() {
        return this.setExplicitlyToNull;
    }

    public boolean isSetExplicitlyToDefault() {
        return this.setExplicitlyToDefault;
    }

    public boolean isIncludeSourceNullCheck() {
        return this.includeSourceNullCheck;
    }

    public static boolean doSourceNullCheck(Assignment rhs, NullValueCheckStrategyGem nvcs, NullValuePropertyMappingStrategyGem nvpms, Type targetType) {
        return !rhs.isSourceReferenceParameter() && !rhs.getSourceType().isPrimitive() && (NullValueCheckStrategyGem.ALWAYS == nvcs || NullValuePropertyMappingStrategyGem.SET_TO_DEFAULT == nvpms || NullValuePropertyMappingStrategyGem.IGNORE == nvpms || rhs.getType().isConverted() || rhs.getType().isDirect() && targetType.isPrimitive());
    }
}

