/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import org.mapstruct.ap.shaded.freemarker.core.ConditionalBlock;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.ParseException;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.core.TemplateObject;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;

final class IfBlock
extends TemplateElement {
    IfBlock(ConditionalBlock block) {
        this.nestedElements = new ArrayList();
        this.addBlock(block);
    }

    void addBlock(ConditionalBlock block) {
        this.nestedElements.add(block);
    }

    void accept(Environment env) throws TemplateException, IOException {
        for (int i = 0; i < this.nestedElements.size(); ++i) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
            Expression condition = cblock.condition;
            env.replaceElementStackTop(cblock);
            if (condition != null && !condition.evalToBoolean(env)) continue;
            if (cblock.nestedBlock != null) {
                env.visitByHiddingParent(cblock.nestedBlock);
            }
            return;
        }
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        if (this.nestedElements.size() == 1) {
            ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(0);
            cblock.isLonelyIf = true;
            cblock.setLocation(this.getTemplate(), (TemplateObject)cblock, (TemplateObject)this);
            return cblock.postParseCleanup(stripWhitespace);
        }
        return super.postParseCleanup(stripWhitespace);
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                ConditionalBlock cblock = (ConditionalBlock)this.nestedElements.get(i);
                buf.append(cblock.dump(canonical));
            }
            buf.append("</#if>");
            return buf.toString();
        }
        return this.getNodeTypeSymbol();
    }

    String getNodeTypeSymbol() {
        return "#if-#elseif-#else-container";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isShownInStackTrace() {
        return false;
    }
}

