/*
 * Decompiled with CFR 0.152.
 */
package org.opencompare.api.java.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.opencompare.api.java.Cell;
import org.opencompare.api.java.Feature;
import org.opencompare.api.java.PCM;
import org.opencompare.api.java.PCMElement;
import org.opencompare.api.java.PCMFactory;
import org.opencompare.api.java.Product;
import org.opencompare.api.java.impl.CellImpl;
import org.opencompare.api.java.impl.PCMImpl;
import org.opencompare.api.java.util.PCMVisitor;

public class ProductImpl
implements Product {
    private org.opencompare.model.Product kProduct;

    public ProductImpl(org.opencompare.model.Product kProduct) {
        this.kProduct = kProduct;
    }

    public org.opencompare.model.Product getkProduct() {
        return this.kProduct;
    }

    public Feature getKey() {
        PCM pcm = this.getPCM();
        return pcm == null ? null : pcm.getProductsKey();
    }

    public Cell getKeyCell() {
        return this.findCell(this.getKey());
    }

    public String getKeyContent() {
        Cell keyCell = this.getKeyCell();
        return keyCell == null ? null : keyCell.getContent();
    }

    public PCM getPCM() {
        org.opencompare.model.PCM kPCM = this.kProduct.getPcm();
        return kPCM == null ? null : new PCMImpl(kPCM);
    }

    public List<Cell> getCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (org.opencompare.model.Cell kCell : this.kProduct.getCells()) {
            cells.add(new CellImpl(kCell));
        }
        return cells;
    }

    public void addCell(Cell cell) {
        this.kProduct.addCells(((CellImpl)cell).getkCell());
    }

    public void removeCell(Cell cell) {
        this.kProduct.removeCells(((CellImpl)cell).getkCell());
    }

    public Cell findCell(Feature feature) {
        if (feature != null) {
            for (Cell cell : this.getCells()) {
                if (!feature.equals(cell.getFeature())) continue;
                return cell;
            }
        }
        return null;
    }

    public void accept(PCMVisitor visitor) {
        visitor.visit((Product)this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Product(" + this.getKeyContent() + ")");
        result.append("(\n");
        for (Cell cell : this.getCells()) {
            result.append(cell.toString() + "\n");
        }
        result.append(")");
        return result.toString();
    }

    public boolean equals(Object o) {
        HashSet<Cell> productCellsSet;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductImpl product = (ProductImpl)o;
        HashSet<Cell> thisCellsSet = new HashSet<Cell>(this.getCells());
        return thisCellsSet.equals(productCellsSet = new HashSet<Cell>(product.getCells()));
    }

    public int hashCode() {
        return Objects.hash(new HashSet<Cell>(this.getCells()));
    }

    public PCMElement clone(PCMFactory factory) {
        Product copy = factory.createProduct();
        for (Cell cell : this.getCells()) {
            copy.addCell((Cell)cell.clone(factory));
        }
        return copy;
    }
}

