/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.io.File;
import java.io.StringWriter;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.revapi.API;
import org.revapi.ArchiveAnalyzer;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.Timing;
import org.revapi.java.compilation.CompilationFuture;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.Compiler;
import org.revapi.java.compilation.InclusionFilter;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementForest;

public final class JavaArchiveAnalyzer
implements ArchiveAnalyzer {
    private final API api;
    private final ExecutorService executor;
    private final ProbingEnvironment probingEnvironment;
    private final AnalysisConfiguration.MissingClassReporting missingClassReporting;
    private final boolean ignoreMissingAnnotations;
    private final boolean skipUseTracking;
    private final Set<File> bootstrapClasspath;
    private CompilationValve compilationValve;
    private InclusionFilter inclusionFilter;

    public JavaArchiveAnalyzer(API api, ExecutorService compilationExecutor, AnalysisConfiguration.MissingClassReporting missingClassReporting, boolean ignoreMissingAnnotations, boolean skipUseTracking, Set<File> bootstrapClasspath, InclusionFilter inclusionFilter) {
        this.api = api;
        this.executor = compilationExecutor;
        this.missingClassReporting = missingClassReporting;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.skipUseTracking = skipUseTracking;
        this.probingEnvironment = new ProbingEnvironment(api);
        this.bootstrapClasspath = bootstrapClasspath;
        this.inclusionFilter = inclusionFilter;
    }

    @Nonnull
    public JavaElementForest analyze() {
        if (Timing.LOG.isDebugEnabled()) {
            Timing.LOG.debug("Starting analysis of " + this.api);
        }
        StringWriter output = new StringWriter();
        Compiler compiler = new Compiler(this.executor, output, this.api.getArchives(), this.api.getSupplementaryArchives());
        try {
            this.compilationValve = compiler.compile(this.probingEnvironment, this.missingClassReporting, this.ignoreMissingAnnotations, this.skipUseTracking, this.bootstrapClasspath, this.inclusionFilter);
            this.probingEnvironment.getTree().setCompilationFuture(new CompilationFuture(this.compilationValve, output));
            if (Timing.LOG.isDebugEnabled()) {
                Timing.LOG.debug("Preliminary API tree produced for " + this.api);
            }
            return this.probingEnvironment.getTree();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to analyze archives in api " + this.api, e);
        }
    }

    public ProbingEnvironment getProbingEnvironment() {
        return this.probingEnvironment;
    }

    public CompilationValve getCompilationValve() {
        return this.compilationValve;
    }
}

