/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.revapi.java.compilation.ProbingEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedAnnotationTypes(value={"__RevapiMarkerAnnotation"})
final class ProbingAnnotationProcessor
extends AbstractProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProbingAnnotationProcessor.class);
    private final ProbingEnvironment environment;

    public ProbingAnnotationProcessor(ProbingEnvironment env) {
        this.environment = env;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.environment.setProcessingEnvironment(this.processingEnv);
            this.releaseCompilationProgress();
            try {
                this.environment.getCompilationTeardownLatch().await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
        return false;
    }

    public <T> Future<T> submitWithCompilationAwareness(ExecutorService executor, final Callable<T> task) throws Exception {
        return executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    Object v = task.call();
                    return v;
                }
                finally {
                    ProbingAnnotationProcessor.this.releaseCompilationProgress();
                }
            }
        });
    }

    private void releaseCompilationProgress() {
        if (LOG.isTraceEnabled() && this.environment.getCompilationProgressLatch().getCount() > 0L) {
            LOG.trace("Releasing compilation progress for " + this.environment.getApi());
        }
        this.environment.getCompilationProgressLatch().countDown();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

