/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.model;

import javax.annotation.Nonnull;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.revapi.Archive;
import org.revapi.Element;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementBase;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.Util;

public final class MethodParameterElement
extends JavaElementBase<VariableElement>
implements JavaMethodParameterElement {
    private final int index;
    private String comparableSignature;

    public MethodParameterElement(ProbingEnvironment env, Archive archive, VariableElement element) {
        super(env, archive, element);
        if (!(element.getEnclosingElement() instanceof ExecutableElement)) {
            throw new IllegalArgumentException("MethodParameterElement cannot be constructed using a VariableElement not representing a method parameter.");
        }
        this.index = ((ExecutableElement)element.getEnclosingElement()).getParameters().indexOf(element);
    }

    @Override
    @Nonnull
    protected String getHumanReadableElementType() {
        return "method parameter";
    }

    @Override
    public int compareTo(@Nonnull Element o) {
        int ret = super.compareTo(o);
        if (ret == 0) {
            MethodParameterElement other = (MethodParameterElement)o;
            ret = this.index - other.index;
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MethodParameterElement)) {
            return false;
        }
        MethodParameterElement other = (MethodParameterElement)((Object)obj);
        ExecutableElement myMethodElement = (ExecutableElement)((VariableElement)this.getModelElement()).getEnclosingElement();
        ExecutableElement otherMethodElement = (ExecutableElement)((VariableElement)other.getModelElement()).getEnclosingElement();
        if (myMethodElement.getParameters().size() != otherMethodElement.getParameters().size()) {
            return false;
        }
        String myType = Util.toUniqueString((TypeMirror)myMethodElement.getEnclosingElement().asType());
        String myMethod = myMethodElement.getSimpleName().toString();
        String otherType = Util.toUniqueString((TypeMirror)otherMethodElement.getEnclosingElement().asType());
        String otherMethod = otherMethodElement.getSimpleName().toString();
        return myType.equals(otherType) && myMethod.equals(otherMethod) && this.index == other.index;
    }

    @Override
    protected String createComparableSignature() {
        String myType = Util.toUniqueString((TypeMirror)((VariableElement)this.getModelElement()).getEnclosingElement().getEnclosingElement().asType());
        String myMethod = ((VariableElement)this.getModelElement()).getEnclosingElement().getSimpleName().toString();
        return myType + "::" + myMethod;
    }
}

