/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks;

import com.carrotsearch.junitbenchmarks.Average;
import com.carrotsearch.junitbenchmarks.GCSnapshot;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Result {
    final Description description;
    public final int benchmarkRounds;
    public final int warmupRounds;
    public final long warmupTime;
    public final long benchmarkTime;
    public final Average roundAverage;
    public final Average blockedAverage;
    public final Average gcAverage;
    public final GCSnapshot gcInfo;
    int concurrency;

    public Result(Description description, int benchmarkRounds, int warmupRounds, long warmupTime, long benchmarkTime, Average roundAverage, Average blockedAverage, Average gcAverage, GCSnapshot gcInfo, int concurrency) {
        this.description = description;
        this.benchmarkRounds = benchmarkRounds;
        this.warmupRounds = warmupRounds;
        this.warmupTime = warmupTime;
        this.benchmarkTime = benchmarkTime;
        this.roundAverage = roundAverage;
        this.blockedAverage = blockedAverage;
        this.gcAverage = gcAverage;
        this.gcInfo = gcInfo;
        this.concurrency = concurrency;
    }

    public String getShortTestClassName() {
        return this.getTestClass().getSimpleName();
    }

    public String getTestClassName() {
        return this.description.getClassName();
    }

    public String getTestMethodName() {
        return this.description.getMethodName();
    }

    public Class<?> getTestClass() {
        return this.description.getTestClass();
    }

    public Method getTestMethod() {
        try {
            return this.getTestClass().getMethod(this.getTestMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Logger.getAnonymousLogger().warning("Could not locate the test method responsible for test: " + this.getTestMethodName());
            return null;
        }
    }

    public int getThreadCount() {
        return this.concurrency;
    }
}

