/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.junitbenchmarks.db;

import com.carrotsearch.junitbenchmarks.Result;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import com.carrotsearch.junitbenchmarks.db.DbConsumer;
import com.carrotsearch.junitbenchmarks.db.GeneratorUtils;
import com.carrotsearch.junitbenchmarks.db.IChartAnnotationVisitor;
import com.carrotsearch.junitbenchmarks.db.MethodChartGenerator;
import java.lang.reflect.Method;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodChartVisitor
implements IChartAnnotationVisitor {
    private HashSet<Class<?>> types = new HashSet();

    MethodChartVisitor() {
    }

    @Override
    public void generate(DbConsumer c) throws Exception {
        for (Class<?> clazz : this.types) {
            MethodChartGenerator g = new MethodChartGenerator(GeneratorUtils.getFilePrefix(clazz, clazz.getAnnotation(BenchmarkMethodChart.class).filePrefix(), c.getChartsDir()), clazz.getName(), c);
            AxisRange ann = clazz.getAnnotation(AxisRange.class);
            if (ann != null) {
                g.min = ann.min();
                g.max = ann.max();
            }
            g.generate();
        }
    }

    @Override
    public void visit(Class<?> clazz, Method method, Result result) {
        if (clazz.isAnnotationPresent(BenchmarkMethodChart.class) && !this.types.contains(clazz)) {
            this.types.add(clazz);
        }
    }
}

