/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.scijava.util.ArrayUtils;
import org.scijava.util.ClassUtils;

public class ConversionUtils {
    private ConversionUtils() {
    }

    public static Object convert(Object value, Type type) {
        Class<?> c = ConversionUtils.getClass(type);
        if (c != null && ConversionUtils.canCast(value, c)) {
            return ConversionUtils.cast(value, c);
        }
        if (ConversionUtils.isArray(type)) {
            return ConversionUtils.convertToArray(value, ConversionUtils.getComponentClass(type));
        }
        if (type instanceof ParameterizedType && ConversionUtils.isCollection(type)) {
            return ConversionUtils.convertToCollection(value, (ParameterizedType)type);
        }
        return ConversionUtils.convert(value, ConversionUtils.getClass(type));
    }

    public static <T> T convert(Object value, Class<T> type) {
        String result;
        if (type == null) {
            return null;
        }
        if (value == null) {
            return ConversionUtils.getNullValue(type);
        }
        Class<T> saneType = ConversionUtils.getNonprimitiveType(type);
        if (ConversionUtils.canCast(value, saneType)) {
            return ConversionUtils.cast(value, saneType);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (saneType == Byte.class) {
                Byte result2;
                Byte typedResult = result2 = Byte.valueOf(number.byteValue());
                return (T)typedResult;
            }
            if (saneType == Double.class) {
                Double result3;
                Double typedResult = result3 = Double.valueOf(number.doubleValue());
                return (T)typedResult;
            }
            if (saneType == Float.class) {
                Float result4;
                Float typedResult = result4 = Float.valueOf(number.floatValue());
                return (T)typedResult;
            }
            if (saneType == Integer.class) {
                Integer result5;
                Integer typedResult = result5 = Integer.valueOf(number.intValue());
                return (T)typedResult;
            }
            if (saneType == Long.class) {
                Long result6;
                Long typedResult = result6 = Long.valueOf(number.longValue());
                return (T)typedResult;
            }
            if (saneType == Short.class) {
                Short result7;
                Short typedResult = result7 = Short.valueOf(number.shortValue());
                return (T)typedResult;
            }
        }
        if (value instanceof String) {
            String s = (String)value;
            if (s.isEmpty()) {
                return ConversionUtils.getNullValue(type);
            }
            if (saneType == Character.class) {
                Character c;
                Character result8 = c = new Character(s.charAt(0));
                return (T)result8;
            }
            if (type.isEnum() && (result = ConversionUtils.convertToEnum(s, type)) != null) {
                return (T)result;
            }
        }
        if (saneType == String.class) {
            String sValue;
            result = sValue = value.toString();
            return (T)result;
        }
        try {
            Constructor<?> ctor = ConversionUtils.getConstructor(saneType, value.getClass());
            if (ctor == null) {
                return null;
            }
            Object instance = ctor.newInstance(value);
            return (T)instance;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static <T> T convertToEnum(String value, Class<T> type) {
        if (value == null || !type.isEnum()) {
            return null;
        }
        try {
            T result;
            T typedResult = result = Enum.valueOf(type, value);
            return typedResult;
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public static boolean canConvert(Class<?> c, Class<?> type) {
        Class<?> saneType = ConversionUtils.getNonprimitiveType(type);
        if (ConversionUtils.canCast(c, saneType)) {
            return true;
        }
        if (ConversionUtils.canCast(ConversionUtils.getNonprimitiveType(c), Number.class) && (ClassUtils.isByte(type) || ClassUtils.isDouble(type) || ClassUtils.isFloat(type) || ClassUtils.isInteger(type) || ClassUtils.isLong(type) || ClassUtils.isShort(type))) {
            return true;
        }
        if (saneType == String.class) {
            return true;
        }
        if (ConversionUtils.canCast(c, String.class)) {
            if (saneType == Character.class) {
                return true;
            }
            if (type.isEnum()) {
                return true;
            }
        }
        try {
            return ConversionUtils.getConstructor(saneType, c) != null;
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean canConvert(Object value, Class<?> type) {
        if (value == null) {
            return true;
        }
        return ConversionUtils.canConvert(value.getClass(), type);
    }

    public static <T> T cast(Object obj, Class<T> type) {
        if (!ConversionUtils.canCast(obj, type)) {
            return null;
        }
        Object result = obj;
        return (T)result;
    }

    public static boolean canCast(Class<?> c, Class<?> type) {
        return type.isAssignableFrom(c);
    }

    public static boolean canCast(Object obj, Class<?> type) {
        return obj == null || ConversionUtils.canCast(obj.getClass(), type);
    }

    public static <T> Class<T> getNonprimitiveType(Class<T> type) {
        Class destType = type == Boolean.TYPE ? Boolean.class : (type == Byte.TYPE ? Byte.class : (type == Character.TYPE ? Character.class : (type == Double.TYPE ? Double.class : (type == Float.TYPE ? Float.class : (type == Integer.TYPE ? Integer.class : (type == Long.TYPE ? Long.class : (type == Short.TYPE ? Short.class : (type == Void.TYPE ? Void.class : type))))))));
        Class<Boolean> result = destType;
        return result;
    }

    public static <T> T getNullValue(Class<T> type) {
        Serializable defaultValue = type == Boolean.TYPE ? Boolean.valueOf(false) : (type == Byte.TYPE ? Byte.valueOf((byte)0) : (type == Character.TYPE ? (Serializable)Character.valueOf('\u0000') : (Serializable)(type == Double.TYPE ? (Number)0.0 : (Number)(type == Float.TYPE ? (Number)Float.valueOf(0.0f) : (Number)(type == Integer.TYPE ? (Number)0 : (Number)(type == Long.TYPE ? (Number)0L : (Number)(type == Short.TYPE ? Short.valueOf((short)0) : null)))))));
        Boolean result = defaultValue;
        return (T)result;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConversionUtils.getClass(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    public static Class<?> getComponentClass(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ConversionUtils.getClass(((GenericArrayType)type).getGenericComponentType());
        }
        return null;
    }

    private static Constructor<?> getConstructor(Class<?> type, Class<?> argType) {
        for (Constructor<?> ctor : type.getConstructors()) {
            Class<?>[] params = ctor.getParameterTypes();
            if (params.length != 1 || !ConversionUtils.canCast(argType, params[0])) continue;
            return ctor;
        }
        return null;
    }

    private static boolean isArray(Type type) {
        return ConversionUtils.getComponentClass(type) != null;
    }

    private static boolean isCollection(Type type) {
        return ConversionUtils.canCast(ConversionUtils.getClass(type), Collection.class);
    }

    private static Object convertToArray(Object value, Class<?> componentType) {
        Collection<?> items = ArrayUtils.toCollection(value);
        Object array = Array.newInstance(componentType, items.size());
        int index = 0;
        for (Object item : items) {
            Array.set(array, index++, ConversionUtils.convert(item, componentType));
        }
        return array;
    }

    private static Object convertToCollection(Object value, ParameterizedType pType) {
        Collection<Object> collection = ConversionUtils.createCollection(ConversionUtils.getClass(pType));
        if (collection == null) {
            return null;
        }
        Collection<?> items = ArrayUtils.toCollection(value);
        Type collectionType = pType.getActualTypeArguments()[0];
        for (Object item : items) {
            collection.add(ConversionUtils.convert(item, collectionType));
        }
        return collection;
    }

    private static Collection<Object> createCollection(Class<?> type) {
        if (type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            if (ConversionUtils.canCast(type, List.class)) {
                return new ArrayList<Object>();
            }
            if (ConversionUtils.canCast(type, Set.class)) {
                return new HashSet<Object>();
            }
            return null;
        }
        try {
            Collection c = (Collection)type.newInstance();
            return c;
        }
        catch (InstantiationException exc) {
            return null;
        }
        catch (IllegalAccessException exc) {
            return null;
        }
    }
}

